/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc;

import java.util.Arrays;
import java.util.Random;
import org.ejml.UtilEjml;
import org.ejml.data.FMatrix1Row;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.FMatrixSparseTriplet;
import org.ejml.dense.row.CommonOps_FDRM;
import org.ejml.ops.ConvertFMatrixStruct;
import org.ejml.sparse.csc.CommonOps_FSCC;

public class RandomMatrices_FSCC {
    public static FMatrixSparseCSC rectangle(int numRows, int numCols, int nz_total, float min, float max, Random rand) {
        int i;
        nz_total = Math.min(numCols * numRows, nz_total);
        int[] selected = UtilEjml.shuffled((int)(numRows * numCols), (int)nz_total, (Random)rand);
        Arrays.sort(selected, 0, nz_total);
        FMatrixSparseCSC ret = new FMatrixSparseCSC(numRows, numCols, nz_total);
        ret.indicesSorted = true;
        int[] hist = new int[numCols];
        for (i = 0; i < nz_total; ++i) {
            int n = selected[i] / numRows;
            hist[n] = hist[n] + 1;
        }
        ret.histogramToStructure(hist);
        for (i = 0; i < nz_total; ++i) {
            int row;
            ret.nz_rows[i] = row = selected[i] % numRows;
            ret.nz_values[i] = rand.nextFloat() * (max - min) + min;
        }
        return ret;
    }

    public static FMatrixSparseCSC rectangle(int numRows, int numCols, int nz_total, Random rand) {
        return RandomMatrices_FSCC.rectangle(numRows, numCols, nz_total, -1.0f, 1.0f, rand);
    }

    public static FMatrixSparseCSC symmetric(int N, int nz_total, float min, float max, Random rand) {
        int Ntriagle = (N * N + N) / 2;
        int[] open = new int[Ntriagle];
        int index = 0;
        for (int row = 0; row < N; ++row) {
            int col = row;
            while (col < N) {
                open[index] = row * N + col;
                ++col;
                ++index;
            }
        }
        UtilEjml.shuffle((int[])open, (int)open.length, (int)0, (int)nz_total, (Random)rand);
        Arrays.sort(open, 0, nz_total);
        FMatrixSparseTriplet A = new FMatrixSparseTriplet(N, N, nz_total * 2);
        for (int i = 0; i < nz_total; ++i) {
            int index2 = open[i];
            int row = index2 / N;
            int col = index2 % N;
            float value = rand.nextFloat() * (max - min) + min;
            if (row == col) {
                A.addItem(row, col, value);
                continue;
            }
            A.addItem(row, col, value);
            A.addItem(col, row, value);
        }
        FMatrixSparseCSC B = new FMatrixSparseCSC(N, N, A.nz_length);
        ConvertFMatrixStruct.convert((FMatrixSparseTriplet)A, (FMatrixSparseCSC)B);
        return B;
    }

    public static FMatrixSparseCSC triangleLower(int dimen, int hessenberg, int nz_total, float min, float max, Random rand) {
        int diag_total = dimen - hessenberg;
        int[] rowStart = new int[dimen];
        int[] rowEnd = new int[dimen];
        int N = 0;
        for (int i = 0; i < dimen; ++i) {
            if (i < dimen - 1 + hessenberg) {
                rowStart[i] = N;
            }
            N += i < hessenberg ? dimen : dimen - 1 - i + hessenberg;
            if (i >= dimen - 1 + hessenberg) continue;
            rowEnd[i] = N;
        }
        nz_total = Math.min(N += dimen - hessenberg, nz_total);
        nz_total = Math.max(diag_total, nz_total);
        int off_total = nz_total - diag_total;
        int[] selected = UtilEjml.shuffled((int)(N - diag_total), (int)off_total, (Random)rand);
        Arrays.sort(selected, 0, off_total);
        FMatrixSparseCSC L = new FMatrixSparseCSC(dimen, dimen, nz_total);
        int[] hist = new int[dimen];
        int s_index = 0;
        for (int col = 0; col < dimen; ++col) {
            if (col >= hessenberg) {
                int n = col;
                hist[n] = hist[n] + 1;
            }
            while (s_index < off_total && selected[s_index] < rowEnd[col]) {
                int n = col;
                hist[n] = hist[n] + 1;
                ++s_index;
            }
        }
        L.histogramToStructure(hist);
        int nz_index = 0;
        s_index = 0;
        for (int col = 0; col < dimen; ++col) {
            int offset;
            int n = offset = col >= hessenberg ? col - hessenberg + 1 : 0;
            if (col >= hessenberg) {
                L.nz_rows[nz_index] = col - hessenberg;
                L.nz_values[nz_index++] = rand.nextFloat() * (max - min) + min;
            }
            while (s_index < off_total && selected[s_index] < rowEnd[col]) {
                int row;
                L.nz_rows[nz_index] = row = selected[s_index++] - rowStart[col] + offset;
                L.nz_values[nz_index++] = rand.nextFloat() * (max - min) + min;
            }
        }
        return L;
    }

    public static FMatrixSparseCSC triangleUpper(int dimen, int hessenberg, int nz_total, float min, float max, Random rand) {
        FMatrixSparseCSC L = RandomMatrices_FSCC.triangleLower(dimen, hessenberg, nz_total, min, max, rand);
        FMatrixSparseCSC U = L.createLike();
        CommonOps_FSCC.transpose(L, U, null);
        return U;
    }

    public static int nonzero(int numRows, int numCols, float minFill, float maxFill, Random rand) {
        int N = numRows * numCols;
        return (int)((float)N * (rand.nextFloat() * (maxFill - minFill) + minFill) + 0.5f);
    }

    public static FMatrixSparseCSC triangle(boolean upper, int N, float minFill, float maxFill, Random rand) {
        int nz = (int)((float)((N - 1) * (N - 1) / 2) * (rand.nextFloat() * (maxFill - minFill) + minFill)) + N;
        if (upper) {
            return RandomMatrices_FSCC.triangleUpper(N, 0, nz, -1.0f, 1.0f, rand);
        }
        return RandomMatrices_FSCC.triangleLower(N, 0, nz, -1.0f, 1.0f, rand);
    }

    public static FMatrixSparseCSC symmetricPosDef(int width, float probabilityZero, Random rand) {
        int i;
        if (probabilityZero < 0.0f || probabilityZero > 1.0f) {
            throw new IllegalArgumentException("Invalid value for probabilityZero");
        }
        FMatrixRMaj a = new FMatrixRMaj(width, 1);
        FMatrixRMaj b = new FMatrixRMaj(width, width);
        for (i = 1; i < width; ++i) {
            if (!(rand.nextFloat() >= probabilityZero)) continue;
            a.set(i, 0, rand.nextFloat() * 2.0f - 1.0f);
        }
        CommonOps_FDRM.multTransB((FMatrix1Row)a, (FMatrix1Row)a, (FMatrix1Row)b);
        for (i = 0; i < width; ++i) {
            b.add(i, i, 1.0f + rand.nextFloat() * 0.1f);
        }
        FMatrixSparseCSC out = new FMatrixSparseCSC(width, width, width);
        ConvertFMatrixStruct.convert((FMatrixRMaj)b, (FMatrixSparseCSC)out, (float)UtilEjml.TEST_F32);
        return out;
    }

    public static void ensureNotSingular(FMatrixSparseCSC A, Random rand) {
        int[] s = UtilEjml.shuffled((int)A.numRows, (Random)rand);
        Arrays.sort(s);
        int N = Math.min(A.numCols, A.numRows);
        for (int col = 0; col < N; ++col) {
            A.set(s[col], col, rand.nextFloat() + 0.5f);
        }
    }
}

