/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryUtils;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.ShapeType;

public class Point
implements Geometry {
    public static final Point EMPTY = new Point();
    private final double lat;
    private final double lon;
    private final boolean empty;

    private Point() {
        this.lat = 0.0;
        this.lon = 0.0;
        this.empty = true;
    }

    public Point(double lat, double lon) {
        GeometryUtils.checkLatitude(lat);
        GeometryUtils.checkLongitude(lon);
        this.lat = lat;
        this.lon = lon;
        this.empty = false;
    }

    @Override
    public ShapeType type() {
        return ShapeType.POINT;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point point = (Point)o;
        if (point.empty != this.empty) {
            return false;
        }
        if (Double.compare(point.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(point.lon, this.lon) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public <T> T visit(GeometryVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        return "lat=" + this.lat + ", lon=" + this.lon;
    }
}

