/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.Properties;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.runtime.util.Inputs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeController {
    private static final Logger logger = LoggerFactory.getLogger(TimeController.class);
    private static final TimeController singleton = new TimeController();
    private volatile ClientState state;
    private volatile long clientStartTime;
    private volatile long currentPhaseStartTime;
    private volatile long timeLeftFromPreviousPhases;
    private Map<ClientState, Long> phaseTimeouts;
    private Map<ClientState, Long> timeSpentInEachPhase;

    protected TimeController() {
        this.init();
    }

    private void init() {
        this.state = ClientState.NOT_STARTED;
        this.clientStartTime = 0L;
        this.timeLeftFromPreviousPhases = 0L;
        this.initializePhaseTimeouts();
    }

    public static void resetSingleton() {
        TimeController.getInstance().init();
    }

    public static void execute(Runnable runnable, String name, long warn_time_ms) {
        Inputs.checkNull((Object[])new Object[]{runnable, name});
        long start = System.currentTimeMillis();
        runnable.run();
        long delta = System.currentTimeMillis() - start;
        if (delta > warn_time_ms) {
            logger.warn("Operation '{}' took too long: {}ms", (Object)name, (Object)delta);
        }
    }

    private void initializePhaseTimeouts() {
        if (this.phaseTimeouts != null) {
            this.phaseTimeouts.clear();
        } else {
            this.phaseTimeouts = new ConcurrentHashMap<ClientState, Long>();
        }
        Properties.getInstance();
        this.phaseTimeouts.put(ClientState.SEARCH, Long.valueOf(1000L) * (long)TimeController.getSearchBudgetInSeconds());
        this.phaseTimeouts.put(ClientState.MINIMIZATION, Long.valueOf(1000L) * (long)Properties.MINIMIZATION_TIMEOUT);
        this.phaseTimeouts.put(ClientState.ASSERTION_GENERATION, Long.valueOf(1000L) * (long)Properties.ASSERTION_TIMEOUT);
        this.phaseTimeouts.put(ClientState.CARVING, Long.valueOf(1000L) * (long)Properties.CARVING_TIMEOUT);
        this.phaseTimeouts.put(ClientState.INITIALIZATION, Long.valueOf(1000L) * (long)Properties.INITIALIZATION_TIMEOUT);
        this.phaseTimeouts.put(ClientState.JUNIT_CHECK, Long.valueOf(1000L) * (long)Properties.JUNIT_CHECK_TIMEOUT);
        this.phaseTimeouts.put(ClientState.WRITING_TESTS, Long.valueOf(1000L) * (long)Properties.WRITE_JUNIT_TIMEOUT);
        if (this.timeSpentInEachPhase != null) {
            this.timeSpentInEachPhase.clear();
        } else {
            this.timeSpentInEachPhase = new ConcurrentHashMap<ClientState, Long>();
        }
    }

    public static TimeController getInstance() {
        return singleton;
    }

    public synchronized void updateState(ClientState newState) throws IllegalArgumentException {
        long timeout;
        long left;
        Inputs.checkNull((Object[])new Object[]{newState});
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (newState.getNumPhase() < this.state.getNumPhase()) {
            throw new IllegalArgumentException("Phase '" + (Object)((Object)newState) + "' cannot be executed after phase '" + (Object)((Object)this.state) + "'");
        }
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            long elapsed = System.currentTimeMillis() - this.currentPhaseStartTime;
            if (this.timeSpentInEachPhase.containsKey((Object)this.state)) {
                logger.warn("Already entered in phase: " + (Object)((Object)this.state) + ". This will mess up the timing calculations.");
            }
            this.timeSpentInEachPhase.put(this.state, elapsed);
            logger.debug("Phase {} lasted {} seconds", (Object)this.state, (Object)(elapsed / 1000L));
            if (this.currentPhaseHasTimeout()) {
                long timeoutInMs = this.getCurrentPhaseTimeout();
                long left2 = timeoutInMs - elapsed;
                if ((double)left2 < -(0.1 * (double)timeoutInMs)) {
                    logger.warn("Phase " + (Object)((Object)this.state) + " lasted too long, " + -left2 / 1000L + " seconds more than allowed.");
                }
                if (Properties.REUSE_LEFTOVER_TIME) {
                    this.timeLeftFromPreviousPhases += left2;
                    logger.info("Time left from previous phases: {}/{} -> {}, {}", new Object[]{left2, timeoutInMs, this.timeLeftFromPreviousPhases, this.getLeftTimeBeforeEnd()});
                }
            }
        }
        this.state = newState;
        this.currentPhaseStartTime = System.currentTimeMillis();
        if (this.state.equals((Object)ClientState.STARTED)) {
            this.clientStartTime = this.currentPhaseStartTime;
        }
        if (this.currentPhaseHasTimeout() && (left = this.getLeftTimeBeforeEnd()) < (timeout = this.getCurrentPhaseTimeout() + this.timeLeftFromPreviousPhases)) {
            logger.warn("Current phase {} could run up to {}s, but only {}s are left", new Object[]{this.state, (int)(timeout / 1000L), (int)(left / 1000L)});
        }
    }

    public static int getSearchBudgetInSeconds() {
        if (Properties.STOPPING_CONDITION == Properties.StoppingCondition.MAXTIME) {
            return (int)Properties.SEARCH_BUDGET;
        }
        return Properties.GLOBAL_TIMEOUT;
    }

    public int calculateForHowLongClientWillRunInSeconds() {
        int time = Properties.EXTRA_TIMEOUT;
        time += Properties.INITIALIZATION_TIMEOUT;
        time += TimeController.getSearchBudgetInSeconds();
        if (Properties.MINIMIZE) {
            time += Properties.MINIMIZATION_TIMEOUT;
        }
        if (Properties.ASSERTIONS) {
            time += Properties.ASSERTION_TIMEOUT;
        }
        if (Properties.TEST_FACTORY == Properties.TestFactory.JUNIT) {
            time += Properties.CARVING_TIMEOUT;
        }
        if (Properties.JUNIT_TESTS) {
            time += Properties.WRITE_JUNIT_TIMEOUT;
            if (Properties.JUNIT_CHECK) {
                time += Properties.JUNIT_CHECK_TIMEOUT;
            }
        }
        return time;
    }

    public synchronized boolean hasTimeToExecuteATestCase() {
        return this.isThereStillTimeInThisPhase(Properties.TIMEOUT);
    }

    public synchronized boolean isThereStillTimeInThisPhase() {
        return this.isThereStillTimeInThisPhase(1L);
    }

    public synchronized boolean isThereStillTimeInThisPhase(long ms) {
        if (this.state.equals((Object)ClientState.NOT_STARTED)) {
            return true;
        }
        long left = this.getLeftTimeBeforeEnd();
        if (ms > left) {
            return false;
        }
        if (this.currentPhaseHasTimeout()) {
            long timeoutInMs = this.getCurrentPhaseTimeout();
            long timeSincePhaseStarted = System.currentTimeMillis() - this.currentPhaseStartTime;
            long phaseLeft = timeoutInMs - timeSincePhaseStarted + this.timeLeftFromPreviousPhases;
            logger.debug("Time left for current phase {}: {}", (Object)this.state, (Object)phaseLeft);
            if (ms > phaseLeft) {
                return false;
            }
        }
        return true;
    }

    private long getLeftTimeBeforeEnd() {
        long timeSinceStart = System.currentTimeMillis() - this.clientStartTime;
        long totalTimeLimit = 1000 * this.calculateForHowLongClientWillRunInSeconds();
        return totalTimeLimit - timeSinceStart;
    }

    public double getPhasePercentage() {
        if (this.currentPhaseHasTimeout()) {
            long timeoutInMs = this.getCurrentPhaseTimeout();
            long timeSincePhaseStarted = System.currentTimeMillis() - this.currentPhaseStartTime;
            double ratio = (double)timeSincePhaseStarted / (double)timeoutInMs;
            assert (ratio >= 0.0);
            return Math.min(ratio, 1.0);
        }
        return -1.0;
    }

    private long getCurrentPhaseTimeout() {
        return this.phaseTimeouts.get((Object)this.state);
    }

    private boolean currentPhaseHasTimeout() {
        return this.phaseTimeouts.containsKey((Object)this.state);
    }
}

