/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Array;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;

public class ArrayLengthAssertion
extends Assertion {
    private static final long serialVersionUID = -3524688649310294677L;
    public int length = 0;

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        ArrayLengthAssertion s = new ArrayLengthAssertion();
        s.source = this.source.copy(newTestCase, offset);
        s.value = this.value;
        s.length = this.length;
        s.comment = this.comment;
        return s;
    }

    @Override
    public String getCode() {
        return "assertEquals(" + this.value + ", " + this.source.getName() + ".length);";
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (this.source.getObject(scope) == null) {
                return this.value == null;
            }
            return Array.getLength(this.source.getObject(scope)) == this.length;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }
}

