/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.VariableReference;

public class CompareAssertion
extends Assertion {
    private static final long serialVersionUID = 7415863202662602633L;
    protected VariableReference dest;

    public VariableReference getDest() {
        return this.dest;
    }

    public void setDest(VariableReference dest) {
        this.dest = dest;
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        CompareAssertion s = new CompareAssertion();
        s.source = newTestCase.getStatement(this.source.getStPosition() + offset).getReturnValue();
        s.dest = newTestCase.getStatement(this.dest.getStPosition() + offset).getReturnValue();
        s.value = this.value;
        s.comment = this.comment;
        s.killedMutants.addAll(this.killedMutants);
        return s;
    }

    @Override
    public String getCode() {
        if (this.source.getType().equals(Integer.class)) {
            if ((Integer)this.value == 0) {
                return "assertTrue(" + this.source.getName() + " == " + this.dest.getName() + ");";
            }
            if ((Integer)this.value < 0) {
                return "assertTrue(" + this.source.getName() + " < " + this.dest.getName() + ");";
            }
            return "assertTrue(" + this.source.getName() + " > " + this.dest.getName() + ");";
        }
        return "assertEquals(" + this.source.getName() + ".compareTo(" + this.dest.getName() + "), " + this.value + ");";
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            Comparable comparable = (Comparable)this.source.getObject(scope);
            if (comparable == null) {
                if ((Integer)this.value == 0) {
                    return this.dest.getObject(scope) == null;
                }
                return true;
            }
            try {
                return comparable.compareTo(this.dest.getObject(scope)) == ((Integer)this.value).intValue();
            }
            catch (Exception e) {
                return true;
            }
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompareAssertion other = (CompareAssertion)obj;
        if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.value == null ? other.value != null : ((Integer)this.value > 0 ? (Integer)other.value <= 0 : ((Integer)this.value < 0 ? (Integer)other.value >= 0 : (Integer)this.value == 0 && (Integer)other.value != 0)));
    }

    @Override
    public Set<VariableReference> getReferencedVariables() {
        HashSet<VariableReference> vars = new HashSet<VariableReference>();
        vars.add(this.source);
        vars.add(this.dest);
        return vars;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.dest != null;
    }
}

