/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.variable.VariableReference;

public class ComparisonTraceEntry
implements OutputTraceEntry {
    private final VariableReference var;
    private final Map<VariableReference, Boolean> equalityMap = new HashMap<VariableReference, Boolean>();
    private final Map<Integer, VariableReference> equalityMapIntVar = new HashMap<Integer, VariableReference>();

    public ComparisonTraceEntry(VariableReference var) {
        this.var = var;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.getClass().equals(Double.class) || a.getClass().equals(Double.TYPE)) {
            if (Double.compare((Double)a, (Double)b) == 0) {
                return true;
            }
            return Math.abs((Double)a - (Double)b) <= Properties.DOUBLE_PRECISION;
        }
        if (a.getClass().equals(Float.class) || a.getClass().equals(Float.TYPE)) {
            if (Float.compare(((Float)a).floatValue(), ((Float)b).floatValue()) == 0) {
                return true;
            }
            return Math.abs(((Float)a).floatValue() - ((Float)b).floatValue()) <= Properties.FLOAT_PRECISION;
        }
        return a.equals(b);
    }

    public void addEntry(VariableReference other, boolean value) {
        this.equalityMap.put(other, value);
        this.equalityMapIntVar.put(other.getStPosition(), other);
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof ComparisonTraceEntry) {
            if (!((ComparisonTraceEntry)other).var.equals(this.var)) {
                return false;
            }
            ComparisonTraceEntry otherEntry = (ComparisonTraceEntry)other;
            for (VariableReference otherVar : this.equalityMap.keySet()) {
                if (!otherEntry.equalityMap.containsKey(otherVar) || ComparisonTraceEntry.equals(otherEntry.equalityMap.get(otherVar), this.equalityMap.get(otherVar))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof ComparisonTraceEntry) {
            ComparisonTraceEntry otherEntry = (ComparisonTraceEntry)other;
            for (Integer otherVar : this.equalityMapIntVar.keySet()) {
                if (!otherEntry.equalityMapIntVar.containsKey(otherVar) || otherVar == null || ComparisonTraceEntry.equals(otherEntry.equalityMap.get(otherEntry.equalityMapIntVar.get(otherVar)), this.equalityMap.get(this.equalityMapIntVar.get(otherVar)))) continue;
                EqualsAssertion assertion = new EqualsAssertion();
                assertion.source = this.var;
                assertion.dest = this.equalityMapIntVar.get(otherVar);
                assertion.value = this.equalityMap.get(this.equalityMapIntVar.get(otherVar));
                if (Properties.isRegression()) {
                    assertion.setComment("// (Comp) Original Value: " + this.equalityMap.get(this.equalityMapIntVar.get(otherVar)) + " | Regression Value: " + otherEntry.equalityMap.get(otherEntry.equalityMapIntVar.get(otherVar)));
                }
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (VariableReference otherVar : this.equalityMap.keySet()) {
            if (otherVar == null) continue;
            EqualsAssertion assertion = new EqualsAssertion();
            assertion.source = this.var;
            assertion.dest = otherVar;
            assertion.value = this.equalityMap.get(otherVar);
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof EqualsAssertion) {
            EqualsAssertion ass = (EqualsAssertion)assertion;
            if (ass.source.equals(this.var) && this.equalityMap.containsKey(ass.dest)) {
                return !ComparisonTraceEntry.equals(this.equalityMap.get(ass.dest), ass.value);
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        ComparisonTraceEntry copy = new ComparisonTraceEntry(this.var);
        copy.equalityMap.putAll(this.equalityMap);
        copy.equalityMapIntVar.putAll(this.equalityMapIntVar);
        return copy;
    }
}

