/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.objectweb.asm.Type;

public class ComparisonTraceObserver
extends AssertionTraceObserver<ComparisonTraceEntry> {
    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        try {
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (statement instanceof AssignmentStatement) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            ComparisonTraceEntry entry = new ComparisonTraceEntry(var);
            int position = statement.getPosition();
            for (VariableReference other : scope.getElements(var.getType())) {
                int otherPos;
                Object otherObject = other.getObject(scope);
                if (otherObject == null || object == otherObject || (otherPos = other.getStPosition()) >= position) continue;
                Statement otherStatement = currentTest.getStatement(otherPos);
                if (statement instanceof PrimitiveStatement && otherStatement instanceof PrimitiveStatement || otherStatement instanceof MethodStatement && ((MethodStatement)otherStatement).getMethodName().equals("hashCode")) continue;
                if (Properties.PURE_EQUALS) {
                    String className = object.getClass().getCanonicalName();
                    String methodName = "equals";
                    String descriptor = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
                    CheapPurityAnalyzer cheapPurityAnalyzer = CheapPurityAnalyzer.getInstance();
                    if (!cheapPurityAnalyzer.isPure(className, methodName, descriptor)) continue;
                }
                try {
                    logger.debug("Comparison of " + var + " with " + other + " is: " + object.equals(otherObject));
                    entry.addEntry(other, ComparisonTraceEntry.equals(object, otherObject));
                }
                catch (Throwable t) {
                    logger.debug("Exception during equals: " + t);
                }
                if (!(object instanceof Comparable)) continue;
            }
            this.trace.addEntry(statement.getPosition(), var, entry);
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

