/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.regression.ObjectDistanceCalculator;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectorTraceEntry
implements OutputTraceEntry {
    private static final Logger logger = LoggerFactory.getLogger(InspectorTraceEntry.class);
    private final Map<Inspector, Object> inspectorMap = new HashMap<Inspector, Object>();
    private final Map<String, Inspector> methodInspectorMap = new HashMap<String, Inspector>();
    private final VariableReference var;

    public InspectorTraceEntry(VariableReference var) {
        this.var = var;
    }

    public void addValue(Inspector inspector, Object value) {
        this.inspectorMap.put(inspector, value);
        this.methodInspectorMap.put(inspector.getClassName() + " " + inspector.getMethodCall(), inspector);
    }

    public int size() {
        return this.inspectorMap.size();
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof InspectorTraceEntry) {
            if (!((InspectorTraceEntry)other).var.equals(this.var)) {
                return false;
            }
            InspectorTraceEntry otherEntry = (InspectorTraceEntry)other;
            for (Inspector inspector : this.inspectorMap.keySet()) {
                logger.debug("Current inspector: " + inspector);
                if (!otherEntry.inspectorMap.containsKey(inspector) || otherEntry.inspectorMap.get(inspector) == null || this.inspectorMap.get(inspector) == null) {
                    logger.debug("Other trace does not have " + inspector);
                    continue;
                }
                if (!otherEntry.inspectorMap.get(inspector).equals(this.inspectorMap.get(inspector))) {
                    return true;
                }
                logger.debug("Value is equal: " + inspector);
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof InspectorTraceEntry) {
            InspectorTraceEntry otherEntry = (InspectorTraceEntry)other;
            for (String inspector : this.methodInspectorMap.keySet()) {
                double distance;
                if (!otherEntry.inspectorMap.containsKey(otherEntry.methodInspectorMap.get(inspector)) || otherEntry.inspectorMap.get(otherEntry.methodInspectorMap.get(inspector)) == null || this.inspectorMap.get(this.methodInspectorMap.get(inspector)) == null || otherEntry.inspectorMap.get(otherEntry.methodInspectorMap.get(inspector)).equals(this.inspectorMap.get(this.methodInspectorMap.get(inspector))) || (distance = ObjectDistanceCalculator.getObjectDistance(this.inspectorMap.get(this.methodInspectorMap.get(inspector)), otherEntry.inspectorMap.get(otherEntry.methodInspectorMap.get(inspector)))) == 0.0) continue;
                InspectorAssertion assertion = new InspectorAssertion();
                assertion.value = this.inspectorMap.get(this.methodInspectorMap.get(inspector));
                assertion.inspector = this.methodInspectorMap.get(inspector);
                assertion.source = this.var;
                if (Properties.isRegression()) {
                    assertion.setComment("// (Inspector) Original Value: " + this.inspectorMap.get(this.methodInspectorMap.get(inspector)) + " | Regression Value: " + otherEntry.inspectorMap.get(otherEntry.methodInspectorMap.get(inspector)));
                }
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (Inspector inspector : this.inspectorMap.keySet()) {
            InspectorAssertion assertion = new InspectorAssertion();
            assertion.value = this.inspectorMap.get(inspector);
            assertion.inspector = inspector;
            assertion.source = this.var;
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof InspectorAssertion) {
            InspectorAssertion ass = (InspectorAssertion)assertion;
            if (ass.source.same(this.var)) {
                if (Properties.isRegression()) {
                    String key = ass.getInspector().getClassName() + " " + ass.getInspector().getMethodCall();
                    Inspector inspector = this.methodInspectorMap.get(key);
                    if (inspector != null && this.inspectorMap.get(inspector) != null && ass.value != null) {
                        return !this.inspectorMap.get(inspector).equals(ass.value);
                    }
                } else if (this.inspectorMap.containsKey(ass.inspector) && this.inspectorMap.get(ass.inspector) != null && ass.value != null) {
                    return !this.inspectorMap.get(ass.inspector).equals(ass.value);
                }
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        InspectorTraceEntry copy = new InspectorTraceEntry(this.var);
        copy.inspectorMap.putAll(this.inspectorMap);
        copy.methodInspectorMap.putAll(this.methodInspectorMap);
        return copy;
    }
}

