/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class PrimitiveFieldTraceObserver
extends AssertionTraceObserver<PrimitiveFieldTraceEntry> {
    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        logger.debug("Checking fields of " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement.isAssignmentStatement()) {
                if (statement.getReturnValue().isArrayIndex()) {
                    return;
                }
                if (statement.getReturnValue().isFieldReference()) {
                    return;
                }
            }
            Object object = var.getObject(scope);
            int position = statement.getPosition();
            if (!(object == null || object.getClass().isPrimitive() || object.getClass().isEnum() || PrimitiveFieldTraceObserver.isWrapperType(object.getClass()))) {
                PrimitiveFieldTraceEntry entry = new PrimitiveFieldTraceEntry(var);
                for (Field field : var.getVariableClass().getFields()) {
                    if (!Modifier.isPublic(field.getModifiers()) || field.getType().equals(Void.TYPE) || !field.getType().isPrimitive() || Modifier.isFinal(field.getModifiers()) || field.isSynthetic()) continue;
                    try {
                        logger.debug("Keeping field " + field + " with value " + field.get(object));
                        entry.addValue(field, field.get(object));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                this.trace.addEntry(position, var, entry);
            }
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

