/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.SameTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class SameTraceObserver
extends AssertionTraceObserver<SameTraceEntry> {
    @Override
    protected void visit(Statement statement, Scope scope, VariableReference var) {
        if (statement.isAssignmentStatement()) {
            return;
        }
        if (statement instanceof PrimitiveStatement) {
            return;
        }
        if (statement instanceof ArrayStatement) {
            return;
        }
        if (statement instanceof ConstructorStatement) {
            return;
        }
        try {
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (var.isPrimitive()) {
                return;
            }
            if (var.isString() && Properties.INLINE) {
                return;
            }
            SameTraceEntry entry = new SameTraceEntry(var);
            for (VariableReference other : scope.getElements(var.getType())) {
                Object otherObject;
                if (other == var || other.isPrimitive() || other.isWrapperType() || (otherObject = other.getObject(scope)) == null || otherObject.getClass() != object.getClass()) continue;
                try {
                    logger.debug("Comparison of {} with {}", (Object)var, (Object)other);
                    entry.addEntry(other, object == otherObject);
                }
                catch (Throwable t) {
                    logger.debug("Exception during equals: " + t);
                }
            }
            this.trace.addEntry(statement.getPosition(), var, entry);
        }
        catch (CodeUnderTestException e) {
            logger.debug("", (Throwable)e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

