/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.Scanner;
import org.evosuite.Properties;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathHandler {
    private static Logger logger = LoggerFactory.getLogger(ClassPathHandler.class);
    private static final ClassPathHandler singleton = new ClassPathHandler();
    private String targetClassPath;
    private String evosuiteClassPath;

    private ClassPathHandler() {
    }

    public static ClassPathHandler getInstance() {
        return singleton;
    }

    public static void resetSingleton() {
        ClassPathHandler.getInstance().targetClassPath = null;
        ClassPathHandler.getInstance().evosuiteClassPath = null;
    }

    public String getEvoSuiteClassPath() {
        if (this.evosuiteClassPath == null) {
            this.evosuiteClassPath = System.getProperty("java.class.path");
        }
        return this.evosuiteClassPath;
    }

    public void setEvoSuiteClassPath(String[] elements) throws IllegalArgumentException {
        String cp;
        this.evosuiteClassPath = cp = this.getClassPath(elements);
    }

    public void changeTargetClassPath(String[] elements) throws IllegalArgumentException {
        String cp;
        Properties.CP = cp = this.getClassPath(elements);
        this.targetClassPath = cp;
    }

    private String getClassPath(String[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("No classpath elements");
        }
        String cp = "";
        boolean first = true;
        for (String entry : elements) {
            this.checkIfValidClasspathEntry(entry);
            if (first) {
                first = false;
            } else {
                cp = cp + File.pathSeparator;
            }
            cp = cp + entry;
        }
        return cp;
    }

    public String getTargetProjectClasspath() {
        if (this.targetClassPath == null) {
            String line = null;
            if (Properties.CP_FILE_PATH != null) {
                File file = new File(Properties.CP_FILE_PATH);
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    Scanner scanner = new Scanner(in);
                    line = scanner.nextLine();
                }
                catch (Exception e) {
                    LoggingUtils.getEvoLogger().error("Error while processing " + file.getAbsolutePath() + " : " + e.getMessage());
                }
            }
            this.targetClassPath = line != null ? line : Properties.CP;
        }
        return this.targetClassPath;
    }

    public static String writeClasspathToFile(String classpath) {
        try {
            File file = File.createTempFile("EvoSuite_classpathFile", ".txt");
            file.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            String line = classpath;
            out.write(line);
            out.newLine();
            out.close();
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create tmp file for classpath specification: " + e.getMessage());
        }
    }

    public void addElementToTargetProjectClassPath(String element) throws IllegalArgumentException {
        this.checkIfValidClasspathEntry(element);
        this.getTargetProjectClasspath();
        if (this.targetClassPath == null || this.targetClassPath.isEmpty()) {
            this.targetClassPath = element;
        } else {
            if (this.targetClassPath.contains(element)) {
                return;
            }
            Properties.CP = this.targetClassPath = this.targetClassPath + File.pathSeparator + element;
        }
    }

    private void checkIfValidClasspathEntry(String element) throws IllegalArgumentException {
        if (element == null || element.isEmpty()) {
            throw new IllegalArgumentException("Empty input element");
        }
        File file = new File(element);
        if (!file.exists()) {
            throw new IllegalArgumentException("Classpath element does not exist on disk at: " + element);
        }
        if (!element.endsWith(".jar") && !file.isDirectory()) {
            throw new IllegalArgumentException("A classpath element should either be a jar or a folder: " + element);
        }
    }

    public String[] getClassPathElementsForTargetProject() {
        String cp = this.getTargetProjectClasspath();
        if (cp == null) {
            return new String[0];
        }
        return cp.split(File.pathSeparator);
    }

    public void changeTargetCPtoTheSameAsEvoSuite() {
        File outDir = new File("target" + File.separator + "classes");
        if (outDir.exists()) {
            this.changeTargetClassPath(new String[]{outDir.getAbsolutePath()});
            File testDir = new File("target" + File.separator + "test-classes");
            if (testDir.exists()) {
                this.addElementToTargetProjectClassPath(testDir.getAbsolutePath());
            }
        } else {
            this.changeTargetClassPath(this.getEvoSuiteClassPath().split(File.pathSeparator));
        }
    }
}

