/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericMethod;

public class EqualsSymmetricContract
extends Contract {
    @Override
    public ContractViolation check(Statement statement, Scope scope, Throwable exception) {
        for (Contract.Pair<VariableReference> pair : this.getAllVariablePairs(scope)) {
            Object object2;
            Object object1;
            block9: {
                if (pair.object1 == pair.object2) continue;
                object1 = scope.getObject((VariableReference)pair.object1);
                object2 = scope.getObject((VariableReference)pair.object2);
                if (object1 == null || object2 == null) continue;
                Class[] parameters = new Class[]{Object.class};
                try {
                    Method equalsMethod = object1.getClass().getMethod("equals", parameters);
                    if (equalsMethod.getDeclaringClass().equals(Object.class)) {
                    }
                    break block9;
                }
                catch (SecurityException e1) {
                }
                catch (NoSuchMethodException e1) {}
                continue;
            }
            ExecutionTracer.disable();
            if (object1.equals(object2)) {
                if (!object2.equals(object1)) {
                    ExecutionTracer.enable();
                    return new ContractViolation(this, statement, exception, (VariableReference)pair.object1, (VariableReference)pair.object2);
                }
            } else if (object2.equals(object1)) {
                ExecutionTracer.enable();
                return new ContractViolation(this, statement, exception, (VariableReference)pair.object1, (VariableReference)pair.object2);
            }
            ExecutionTracer.enable();
        }
        return null;
    }

    @Override
    public void addAssertionAndComments(Statement statement, List<VariableReference> variables, Throwable exception) {
        TestCase test = statement.getTestCase();
        VariableReference a = variables.get(0);
        VariableReference b = variables.get(1);
        try {
            Method equalsMethod = a.getGenericClass().getRawClass().getMethod("equals", Object.class);
            GenericMethod method = new GenericMethod(equalsMethod, a.getGenericClass());
            MethodStatement st1 = new MethodStatement(test, method, a, Arrays.asList(b));
            VariableReference x = test.addStatement(st1, statement.getPosition() + 1);
            MethodStatement st2 = new MethodStatement(test, method, b, Arrays.asList(a));
            VariableReference y = test.addStatement(st2, statement.getPosition() + 2);
            Statement newStatement = test.getStatement(y.getStPosition());
            EqualsAssertion assertion = new EqualsAssertion();
            assertion.setStatement(newStatement);
            assertion.setSource(x);
            assertion.setDest(y);
            assertion.setValue(true);
            newStatement.addAssertion(assertion);
            newStatement.addComment("Violates contract a.equals(b) <-> b.equals(a)");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "Equals symmetric check";
    }
}

