/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefUse
extends BytecodeInstruction {
    private static final long serialVersionUID = -2643584238269671760L;
    private static final Logger logger = LoggerFactory.getLogger(DefUse.class);
    protected int defuseId;
    protected int defId;
    protected int useId;
    protected boolean isParameterUse;
    protected boolean isFieldMethodCall;
    protected boolean isFieldMethodCallDefinition;
    protected boolean isFieldMethodCallUse;
    protected boolean isInStaticMethod;
    protected String varName;

    protected DefUse(BytecodeInstruction wrap) {
        super(wrap);
        if (!DefUsePool.isKnown(wrap)) {
            throw new IllegalArgumentException("only instructions known by the DefUsePool are accepted");
        }
        this.defuseId = DefUsePool.getRegisteredDefUseId(wrap);
        if (this.defuseId < 0) {
            throw new IllegalArgumentException("expect defUseId to be positive");
        }
        this.defId = DefUsePool.getRegisteredDefId(wrap);
        this.useId = DefUsePool.getRegisteredUseId(wrap);
        if (this.defId < 0 && this.useId < 0) {
            throw new IllegalArgumentException("expect either defId or useId to be set");
        }
        this.isParameterUse = DefUsePool.isKnownAsParameterUse(wrap);
        this.isFieldMethodCall = DefUsePool.isKnownAsFieldMethodCall(wrap);
        if (this.isFieldMethodCall) {
            if (DefUsePool.isKnownAsDefinition(wrap)) {
                this.isFieldMethodCallDefinition = true;
            }
            if (DefUsePool.isKnownAsUse(wrap)) {
                this.isFieldMethodCallUse = true;
            }
            if (!this.isFieldMethodCallDefinition && !this.isFieldMethodCallUse) {
                throw new IllegalStateException("field method calls only accepted once they got categorized");
            }
        }
        this.isInStaticMethod = this.getRawCFG().isStaticMethod();
        this.varName = super.getVariableName();
        if (this.varName == null) {
            throw new IllegalStateException("expect defUses to have non-null variable name. Instruction: " + wrap + "," + wrap.getASMNode().getPrevious() + ", method: " + wrap.getClassName() + "." + wrap.getMethodName());
        }
    }

    @Override
    public boolean isFieldMethodCallDefinition() {
        return this.isFieldMethodCallDefinition;
    }

    @Override
    public boolean isFieldMethodCallUse() {
        return this.isFieldMethodCallUse;
    }

    public boolean canBecomeActiveDefinition(BytecodeInstruction instruction) {
        if (!instruction.isDefinition()) {
            return false;
        }
        return this.sharesVariableWith(instruction);
    }

    public boolean sharesVariableWith(DefUse du) {
        return this.varName.equals(du.varName);
    }

    public boolean sharesVariableWith(BytecodeInstruction instruction) {
        if (!instruction.isDefUse()) {
            return false;
        }
        return this.varName.equals(instruction.getVariableName());
    }

    public String getDUVariableType() {
        if (this.isMethodCallOfField()) {
            return "FieldMethodCall";
        }
        if (this.isFieldDU()) {
            return "Field";
        }
        if (this.isParameterUse()) {
            return "Parameter";
        }
        if (this.isLocalDU()) {
            return "Local";
        }
        logger.warn("unexpected state");
        return "UNKNOWN";
    }

    @Override
    public String getVariableName() {
        return this.varName;
    }

    public int getDefUseId() {
        return this.defuseId;
    }

    public int getUseId() {
        return this.useId;
    }

    public int getDefId() {
        return this.defId;
    }

    public boolean isParameterUse() {
        return this.isParameterUse;
    }

    @Override
    public String toString() {
        StringBuilder r = new StringBuilder();
        if (this.isDefinition()) {
            r.append("Definition " + this.getDefId());
        }
        if (this.isUse()) {
            r.append("Use " + this.getUseId());
        }
        r.append(" for ");
        if (this.isStaticDefUse()) {
            r.append("static ");
        }
        r.append(this.getDUVariableType());
        r.append("-Variable \"" + this.getVariableName() + "\"");
        r.append(" in " + this.getMethodName() + "." + this.getInstructionId());
        if (this.isRootBranchDependent()) {
            r.append(" root-Branch");
        } else {
            r.append(" Branch " + this.getControlDependentBranchId() + (this.getControlDependentBranchExpressionValue() ? "t" : "f"));
        }
        r.append(" Line " + this.getLineNumber());
        return r.toString();
    }

    @Override
    public boolean loadsReferenceToThis() {
        if (this.isInStaticMethod) {
            return false;
        }
        return this.asmNode.getOpcode() == 25 && this.getLocalVariableSlot() == 0;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.defId;
        result = 31 * result + this.defuseId;
        result = 31 * result + (this.isFieldMethodCall ? 1231 : 1237);
        result = 31 * result + (this.isFieldMethodCallDefinition ? 1231 : 1237);
        result = 31 * result + (this.isFieldMethodCallUse ? 1231 : 1237);
        result = 31 * result + (this.isParameterUse ? 1231 : 1237);
        result = 31 * result + this.useId;
        result = 31 * result + (this.varName == null ? 0 : this.varName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefUse other = (DefUse)obj;
        if (this.defId != other.defId) {
            return false;
        }
        if (this.defuseId != other.defuseId) {
            return false;
        }
        if (this.isFieldMethodCall != other.isFieldMethodCall) {
            return false;
        }
        if (this.isFieldMethodCallDefinition != other.isFieldMethodCallDefinition) {
            return false;
        }
        if (this.isFieldMethodCallUse != other.isFieldMethodCallUse) {
            return false;
        }
        if (this.isParameterUse != other.isParameterUse) {
            return false;
        }
        if (this.useId != other.useId) {
            return false;
        }
        return !(this.varName == null ? other.varName != null : !this.varName.equals(other.varName));
    }
}

