/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.runtime.mock.OverrideMock;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.objectweb.asm.Type;

public class ExceptionCoverageHelper {
    public static Class<?> getExceptionClass(ExecutionResult result, int exceptionPosition) {
        Throwable t = result.getExceptionThrownAtPosition(exceptionPosition);
        if (t instanceof OverrideMock) {
            return t.getClass().getSuperclass();
        }
        return t.getClass();
    }

    public static ExceptionCoverageTestFitness.ExceptionType getType(ExecutionResult result, int exceptionPosition) {
        if (ExceptionCoverageHelper.isDeclared(result, exceptionPosition)) {
            return ExceptionCoverageTestFitness.ExceptionType.DECLARED;
        }
        if (ExceptionCoverageHelper.isExplicit(result, exceptionPosition)) {
            return ExceptionCoverageTestFitness.ExceptionType.EXPLICIT;
        }
        return ExceptionCoverageTestFitness.ExceptionType.IMPLICIT;
    }

    public static boolean isExplicit(ExecutionResult result, int exceptionPosition) {
        return result.explicitExceptions.containsKey(exceptionPosition) && result.explicitExceptions.get(exceptionPosition) != false;
    }

    public static boolean isDeclared(ExecutionResult result, int exceptionPosition) {
        Throwable t = result.getExceptionThrownAtPosition(exceptionPosition);
        for (Class<?> declaredExceptionClass : result.test.getStatement(exceptionPosition).getDeclaredExceptions()) {
            if (!declaredExceptionClass.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    public static String getMethodIdentifier(ExecutionResult result, int exceptionPosition) {
        if (result.test.getStatement(exceptionPosition) instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)result.test.getStatement(exceptionPosition);
            Method method = ms.getMethod().getMethod();
            return method.getName() + Type.getMethodDescriptor((Method)method);
        }
        if (result.test.getStatement(exceptionPosition) instanceof ConstructorStatement) {
            ConstructorStatement cs = (ConstructorStatement)result.test.getStatement(exceptionPosition);
            Constructor<?> constructor = cs.getConstructor().getConstructor();
            return "<init>" + Type.getConstructorDescriptor(constructor);
        }
        return "";
    }

    public static boolean isSutException(ExecutionResult result, int exceptionPosition) {
        if (result.test.getStatement(exceptionPosition) instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)result.test.getStatement(exceptionPosition);
            Method method = ms.getMethod().getMethod();
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (method.getDeclaringClass().equals(targetClass)) {
                return true;
            }
        } else if (result.test.getStatement(exceptionPosition) instanceof ConstructorStatement) {
            ConstructorStatement cs = (ConstructorStatement)result.test.getStatement(exceptionPosition);
            Constructor<?> constructor = cs.getConstructor().getConstructor();
            Class<?> targetClass = Properties.getTargetClassAndDontInitialise();
            if (constructor.getDeclaringClass().equals(targetClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean shouldSkip(ExecutionResult result, int exceptionPosition) {
        if (exceptionPosition >= result.test.size()) {
            return true;
        }
        Throwable t = result.getExceptionThrownAtPosition(exceptionPosition);
        if (t instanceof SecurityException && Properties.SANDBOX) {
            return true;
        }
        if (t instanceof CodeUnderTestException) {
            return true;
        }
        if (t.getStackTrace() != null && t.getStackTrace().length > 0 && t.getStackTrace()[0] != null) {
            if (t.getStackTrace()[0].getClassName().startsWith(PackageInfo.getEvoSuitePackage() + ".testcase")) {
                return true;
            }
            if (t.getStackTrace()[0].getClassName().startsWith(Enum.class.getCanonicalName()) && t.getStackTrace()[0].getMethodName().startsWith("valueOf")) {
                return true;
            }
        }
        return false;
    }
}

