/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.io.input.InputCoverageGoal;
import org.evosuite.coverage.io.input.InputObserver;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.objectweb.asm.Type;

public class InputCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 6630097528288524492L;
    private final InputCoverageGoal goal;

    public InputCoverageTestFitness(InputCoverageGoal goal) throws IllegalArgumentException {
        if (goal == null) {
            throw new IllegalArgumentException("goal cannot be null");
        }
        this.goal = goal;
        boolean hasObserver = false;
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        for (ExecutionObserver ob : executor.getExecutionObservers()) {
            if (!(ob instanceof InputObserver)) continue;
            hasObserver = true;
            break;
        }
        if (!hasObserver) {
            InputObserver observer = new InputObserver();
            executor.addObserver(observer);
            logger.info("Added observer for input coverage");
        }
    }

    public String getClassName() {
        return this.goal.getClassName();
    }

    public String getMethod() {
        return this.goal.getMethodName();
    }

    public Type getType() {
        return this.goal.getType();
    }

    public String getValueDescriptor() {
        return this.goal.getValueDescriptor();
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        block0: for (Set<InputCoverageGoal> coveredGoals : result.getInputGoals().values()) {
            if (!coveredGoals.contains(this.goal)) continue;
            for (InputCoverageGoal coveredGoal : coveredGoals) {
                double distance;
                if (!coveredGoal.equals(this.goal) || (distance = this.calculateDistance(coveredGoal)) < 0.0) continue;
                fitness = distance;
                continue block0;
            }
        }
        assert (fitness >= 0.0);
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    private double calculateDistance(InputCoverageGoal coveredGoal) {
        Number argValue = coveredGoal.getNumericValue();
        switch (coveredGoal.getType().getSort()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                assert (argValue != null);
                assert (argValue instanceof Number);
                double doubleValue = argValue.doubleValue();
                if (Double.isNaN(doubleValue)) {
                    return -1.0;
                }
                double distanceToNegative = 0.0;
                double distanceToZero = 0.0;
                double distanceToPositive = 0.0;
                if (doubleValue < 0.0) {
                    distanceToNegative = 0.0;
                    distanceToZero = Math.abs(doubleValue);
                    distanceToPositive = Math.abs(doubleValue) + 1.0;
                } else if (doubleValue == 0.0) {
                    distanceToNegative = 1.0;
                    distanceToZero = 0.0;
                    distanceToPositive = 1.0;
                } else {
                    distanceToNegative = doubleValue + 1.0;
                    distanceToZero = doubleValue;
                    distanceToPositive = 0.0;
                }
                if (coveredGoal.getValueDescriptor().equals("Negative")) {
                    return distanceToNegative;
                }
                if (coveredGoal.getValueDescriptor().equals("Zero")) {
                    return distanceToZero;
                }
                if (!coveredGoal.getValueDescriptor().equals("Positive")) break;
                return distanceToPositive;
            }
            case 2: {
                char charValue = (char)argValue.intValue();
                double distanceToAlpha = 0.0;
                if (charValue < 'A') {
                    distanceToAlpha = 65 - charValue;
                } else if (charValue > 'z') {
                    distanceToAlpha = charValue - 122;
                } else if (charValue < 'a' && charValue > 'Z') {
                    distanceToAlpha = Math.min(97 - charValue, charValue - 90);
                }
                double distanceToDigit = 0.0;
                if (charValue < '0') {
                    distanceToDigit = 48 - charValue;
                } else if (charValue > '9') {
                    distanceToDigit = charValue - 57;
                }
                double distanceToOther = 0.0;
                if (charValue > '0' && charValue < '9') {
                    distanceToAlpha = Math.min(charValue - 48, 57 - charValue);
                } else if (charValue > 'A' && charValue < 'Z') {
                    distanceToAlpha = Math.min(charValue - 65, 90 - charValue);
                } else if (charValue > 'a' && charValue < 'z') {
                    distanceToAlpha = Math.min(charValue - 65, 90 - charValue);
                }
                if (coveredGoal.getValueDescriptor().equals("AlphabeticChar")) {
                    return distanceToAlpha;
                }
                if (coveredGoal.getValueDescriptor().equals("Digit")) {
                    return distanceToDigit;
                }
                if (!coveredGoal.getValueDescriptor().equals("OtherChar")) break;
                return distanceToOther;
            }
            default: {
                return 0.0;
            }
        }
        return 0.0;
    }

    public String toString() {
        return "[Input]: " + this.goal.toString();
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.goal.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputCoverageTestFitness other = (InputCoverageTestFitness)obj;
        return this.goal.equals(other.goal);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof InputCoverageTestFitness) {
            InputCoverageTestFitness otherInputFitness = (InputCoverageTestFitness)other;
            return this.goal.compareTo(otherInputFitness.goal);
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

