/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.method.MethodTraceCoverageTestFitness;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.objectweb.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodTraceCoverageFactory
extends AbstractFitnessFactory<MethodTraceCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(MethodTraceCoverageFactory.class);

    protected static boolean isUsable(Method m) {
        return !m.isSynthetic() && !m.isBridge() && !Modifier.isNative(m.getModifiers()) && !m.getName().contains("<clinit>");
    }

    protected static boolean isUsable(Constructor<?> c) {
        return !c.isSynthetic() && !Modifier.isNative(c.getModifiers()) && !c.getName().contains("<clinit>");
    }

    @Override
    public List<MethodTraceCoverageTestFitness> getCoverageGoals() {
        ArrayList<MethodTraceCoverageTestFitness> goals = new ArrayList<MethodTraceCoverageTestFitness>();
        long start = System.currentTimeMillis();
        String className = Properties.TARGET_CLASS;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (clazz != null) {
            Class<?>[] innerClasses;
            goals.addAll(this.getCoverageGoals(clazz, className));
            for (Class<?> innerClass : innerClasses = clazz.getDeclaredClasses()) {
                String innerClassName = innerClass.getCanonicalName();
                goals.addAll(this.getCoverageGoals(innerClass, innerClassName));
            }
        }
        goalComputationTime = System.currentTimeMillis() - start;
        return goals;
    }

    private List<MethodTraceCoverageTestFitness> getCoverageGoals(Class<?> clazz, String className) {
        Method[] allMethods;
        Constructor<?>[] allConstructors;
        ArrayList<MethodTraceCoverageTestFitness> goals = new ArrayList<MethodTraceCoverageTestFitness>();
        for (Constructor<?> c : allConstructors = clazz.getDeclaredConstructors()) {
            if (!TestUsageChecker.canUse(c)) continue;
            String methodName = "<init>" + Type.getConstructorDescriptor(c);
            logger.info("Adding goal for constructor " + className + "." + methodName);
            goals.add(new MethodTraceCoverageTestFitness(className, methodName));
        }
        for (Method m : allMethods = clazz.getDeclaredMethods()) {
            if (!TestUsageChecker.canUse(m)) continue;
            if (clazz.isEnum() && (m.getName().equals("valueOf") || m.getName().equals("values") || m.getName().equals("ordinal"))) {
                logger.debug("Excluding valueOf for Enum " + m.toString());
                continue;
            }
            String methodName = m.getName() + Type.getMethodDescriptor((Method)m);
            logger.info("Adding goal for method " + className + "." + methodName);
            goals.add(new MethodTraceCoverageTestFitness(className, methodName));
        }
        return goals;
    }

    public static MethodTraceCoverageTestFitness createMethodTestFitness(String className, String method) {
        return new MethodTraceCoverageTestFitness(className, method.substring(method.lastIndexOf(".") + 1));
    }

    public static MethodTraceCoverageTestFitness createMethodTestFitness(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        return MethodTraceCoverageFactory.createMethodTestFitness(instruction.getClassName(), instruction.getMethodName());
    }
}

