/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import org.evosuite.Properties;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class MethodTraceCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = -8880071948317243336L;
    protected final String className;
    protected final String methodName;

    public MethodTraceCoverageTestFitness(String className, String methodName) throws IllegalArgumentException {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("className and methodName cannot be null");
        }
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        String thisCanonicalName = this.className + "." + this.methodName;
        for (String key : result.getTrace().getMethodExecutionCount().keySet()) {
            String canonicalName = key.replace('$', '.');
            if (!canonicalName.equals(thisCanonicalName)) continue;
            fitness = 0.0;
            break;
        }
        this.updateIndividual(this, individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    public String toString() {
        return this.className + "." + this.methodName;
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodTraceCoverageTestFitness other = (MethodTraceCoverageTestFitness)obj;
        if (this.className != other.className) {
            return false;
        }
        return this.methodName.equals(other.methodName);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof MethodTraceCoverageTestFitness) {
            MethodTraceCoverageTestFitness otherMethodFitness = (MethodTraceCoverageTestFitness)other;
            if (this.className.equals(otherMethodFitness.getClassName())) {
                return this.methodName.compareTo(otherMethodFitness.getMethod());
            }
            return this.className.compareTo(otherMethodFitness.getClassName());
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

