/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationSuiteFitness;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.coverage.mutation.StrongMutationTestFitness;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class StrongMutationSuiteFitness
extends MutationSuiteFitness {
    private static final long serialVersionUID = -9124328839917834720L;

    @Override
    public ExecutionResult runTest(TestCase test) {
        return this.runTest(test, null);
    }

    @Override
    public ExecutionResult runTest(TestCase test, Mutation mutant) {
        return StrongMutationTestFitness.runTest(test, mutant);
    }

    private List<TestChromosome> prioritizeTests(TestSuiteChromosome individual) {
        ArrayList<TestChromosome> executionOrder = new ArrayList<TestChromosome>(individual.getTestChromosomes());
        Collections.sort(executionOrder, new Comparator<TestChromosome>(){

            @Override
            public int compare(TestChromosome tc1, TestChromosome tc2) {
                ExecutionResult result1 = tc1.getLastExecutionResult();
                ExecutionResult result2 = tc2.getLastExecutionResult();
                long diff = result1.getExecutionTime() - result2.getExecutionTime();
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        return executionOrder;
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        this.runTestSuite(individual);
        TestSuiteChromosome suite = (TestSuiteChromosome)individual;
        for (TestChromosome test : suite.getTestChromosomes()) {
            ExecutionResult result = test.getLastExecutionResult();
            if (!result.hasTimeout() && !result.hasTestException()) continue;
            logger.debug("Skipping test with timeout");
            double fitness = this.branchFitness.totalGoals * 2 + this.branchFitness.totalMethods + 3 * this.numMutants;
            this.updateIndividual(this, individual, fitness);
            suite.setCoverage(this, 0.0);
            logger.info("Test case has timed out, setting fitness to max value " + fitness);
            return fitness;
        }
        logger.debug("Calculating branch fitness: ");
        double fitness = this.branchFitness.getFitness(individual);
        LinkedHashSet<Integer> touchedMutants = new LinkedHashSet<Integer>();
        LinkedHashMap<Mutation, Double> minMutantFitness = new LinkedHashMap<Mutation, Double>();
        for (Integer mutantId : this.mutantMap.keySet()) {
            MutationTestFitness mutantFitness = (MutationTestFitness)this.mutantMap.get(mutantId);
            minMutantFitness.put(mutantFitness.getMutation(), 3.0);
        }
        int mutantsChecked = 0;
        int numKilled = this.removedMutants.size();
        LinkedHashSet<Integer> newKilled = new LinkedHashSet<Integer>();
        List<TestChromosome> executionOrder = this.prioritizeTests(suite);
        for (TestChromosome test : executionOrder) {
            ExecutionResult result = test.getLastExecutionResult();
            if (result.calledReflection()) continue;
            ExecutionTrace trace = result.getTrace();
            touchedMutants.addAll(trace.getTouchedMutants());
            logger.debug("Tests touched " + touchedMutants.size() + " mutants");
            Map<Integer, Double> touchedMutantsDistances = trace.getMutationDistances();
            if (touchedMutantsDistances.isEmpty()) continue;
            for (Map.Entry entry : this.mutantMap.entrySet()) {
                int mutantID = (Integer)entry.getKey();
                if (newKilled.contains(mutantID)) continue;
                MutationTestFitness goal = (MutationTestFitness)entry.getValue();
                if (MutationTimeoutStoppingCondition.isDisabled(goal.getMutation())) {
                    logger.debug("Skipping timed out mutation " + goal.getMutation().getId());
                    continue;
                }
                ++mutantsChecked;
                double mutantInfectionDistance = 3.0;
                boolean hasBeenTouched = touchedMutantsDistances.containsKey(mutantID);
                if (hasBeenTouched) {
                    if (touchedMutantsDistances.get(mutantID) == 0.0) {
                        logger.debug("Executing test against mutant " + goal.getMutation());
                        mutantInfectionDistance = goal.getFitness(test, result);
                    } else {
                        mutantInfectionDistance = 1.0 + StrongMutationSuiteFitness.normalize(touchedMutantsDistances.get(mutantID));
                    }
                } else {
                    mutantInfectionDistance = goal.getFitness(test, result);
                }
                if (mutantInfectionDistance == 0.0) {
                    ++numKilled;
                    newKilled.add(mutantID);
                    result.test.addCoveredGoal(goal);
                    this.toRemoveMutants.add(mutantID);
                    continue;
                }
                minMutantFitness.put(goal.getMutation(), Math.min(mutantInfectionDistance, (Double)minMutantFitness.get(goal.getMutation())));
            }
        }
        for (Double fit : minMutantFitness.values()) {
            fitness += fit.doubleValue();
        }
        logger.debug("Mutants killed: {}, Checked: {}, Goals: {})", new Object[]{numKilled, mutantsChecked, this.numMutants});
        this.updateIndividual(this, individual, fitness);
        assert (numKilled == newKilled.size() + this.removedMutants.size());
        assert (numKilled <= this.numMutants);
        double coverage = (double)numKilled / (double)this.numMutants;
        assert (coverage >= 0.0 && coverage <= 1.0);
        suite.setCoverage(this, coverage);
        suite.setNumOfCoveredGoals(this, numKilled);
        return fitness;
    }
}

