/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.localsearch;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchObjective;

public class DefaultLocalSearchObjective<T extends Chromosome>
implements LocalSearchObjective<T>,
Serializable {
    private static final long serialVersionUID = -8640106627078837108L;
    private final List<FitnessFunction<? extends Chromosome>> fitnessFunctions = new ArrayList<FitnessFunction<? extends Chromosome>>();
    private boolean isMaximization = false;

    @Override
    public boolean isDone() {
        throw new UnsupportedOperationException("Not implemented for default objective");
    }

    @Override
    public boolean hasImproved(T chromosome) {
        throw new UnsupportedOperationException("Not implemented for default objective");
    }

    @Override
    public void addFitnessFunction(FitnessFunction<? extends Chromosome> fitness) {
        for (FitnessFunction<? extends Chromosome> ff : this.fitnessFunctions) {
            if (ff.isMaximizationFunction() == fitness.isMaximizationFunction()) continue;
            throw new RuntimeException("Local search only supports composition of multiple criteria");
        }
        this.isMaximization = fitness.isMaximizationFunction();
        this.fitnessFunctions.add(fitness);
    }

    @Override
    public boolean isMaximizationObjective() {
        return this.isMaximization;
    }

    @Override
    public List<FitnessFunction<? extends Chromosome>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }

    @Override
    public int hasChanged(T chromosome) {
        throw new UnsupportedOperationException("Not implemented for default objective");
    }

    @Override
    public boolean hasNotWorsened(T chromosome) {
        throw new UnsupportedOperationException("Not implemented for default objective");
    }
}

