/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSearch<T extends Chromosome>
extends GeneticAlgorithm<T> {
    private static final Logger logger = LoggerFactory.getLogger(RandomSearch.class);
    private static final long serialVersionUID = -7685015421245920459L;

    public RandomSearch(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        Object newChromosome = this.chromosomeFactory.getChromosome();
        this.getFitnessFunction().getFitness(newChromosome);
        this.notifyEvaluation((Chromosome)newChromosome);
        if (((Chromosome)newChromosome).compareTo((Chromosome)this.getBestIndividual()) <= 0) {
            logger.info("New fitness: " + ((Chromosome)newChromosome).getFitness());
            this.population.set(0, newChromosome);
        }
        ++this.currentIteration;
    }

    @Override
    public void initializePopulation() {
        this.generateRandomPopulation(1);
        this.calculateFitnessAndSortPopulation();
    }

    @Override
    public void generateSolution() {
        this.notifySearchStarted();
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.currentIteration = 0;
        while (!this.isFinished()) {
            this.evolve();
            this.notifyIteration();
        }
        this.updateBestIndividualFromArchive();
        this.notifySearchFinished();
    }
}

