/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.lips.BudgetConsumptionMonitor;
import org.evosuite.ga.metaheuristics.mosa.AbstractMOSA;
import org.evosuite.ga.metaheuristics.mosa.CrowdingDistance;
import org.evosuite.ga.metaheuristics.mosa.comparators.OnlyCrowdingComparator;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MOSA<T extends Chromosome>
extends AbstractMOSA<T> {
    private static final long serialVersionUID = 146182080947267628L;
    private static final Logger logger = LoggerFactory.getLogger(MOSA.class);
    protected Map<FitnessFunction<T>, T> archive = new LinkedHashMap<FitnessFunction<T>, T>();
    protected Set<FitnessFunction<T>> uncoveredGoals = new LinkedHashSet<FitnessFunction<T>>();
    protected CrowdingDistance<T> distance = new CrowdingDistance();
    protected BudgetConsumptionMonitor budgetMonitor = new BudgetConsumptionMonitor();

    public MOSA(ChromosomeFactory<T> factory) {
        super(factory);
    }

    @Override
    protected void evolve() {
        List offspringPopulation = this.breedNextGeneration();
        ArrayList union = new ArrayList();
        union.addAll(this.population);
        union.addAll(offspringPopulation);
        logger.debug("Union Size =" + union.size());
        this.ranking.computeRankingAssignment(union, this.uncoveredGoals);
        int remain = this.population.size();
        int index = 0;
        List front = null;
        this.population.clear();
        front = this.ranking.getSubfront(index);
        while (remain > 0 && remain >= front.size() && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, this.uncoveredGoals);
            this.population.addAll(front);
            ++index;
            if ((remain -= front.size()) <= 0) continue;
            front = this.ranking.getSubfront(index);
        }
        if (remain > 0 && !front.isEmpty()) {
            this.distance.fastEpsilonDominanceAssignment(front, this.uncoveredGoals);
            Collections.sort(front, new OnlyCrowdingComparator());
            for (int k = 0; k < remain; ++k) {
                this.population.add(front.get(k));
            }
            remain = 0;
        }
        ++this.currentIteration;
    }

    @Override
    protected void calculateFitness(T c) {
        for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
            double value = fitnessFunction.getFitness(c);
            if (value != 0.0) continue;
            this.updateArchive(c, fitnessFunction);
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            List<ExceptionCoverageTestFitness> list = this.deriveCoveredExceptions(c);
            for (ExceptionCoverageTestFitness exp : list) {
                this.updateArchive(c, exp);
                if (this.fitnessFunctions.contains(exp)) continue;
                this.fitnessFunctions.add(exp);
                ExceptionCoverageFactory.getGoals().put(exp.toString(), exp);
            }
        }
        this.notifyEvaluation((Chromosome)c);
        this.budgetMonitor.checkMaxCoverage(this.archive.keySet().size());
    }

    @Override
    public void generateSolution() {
        logger.info("executing generateSolution function");
        for (FitnessFunction goal : this.fitnessFunctions) {
            this.uncoveredGoals.add(goal);
        }
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        this.ranking.computeRankingAssignment(this.population, this.uncoveredGoals);
        for (int i = 0; i < this.ranking.getNumberOfSubfronts(); ++i) {
            this.distance.fastEpsilonDominanceAssignment(this.ranking.getSubfront(i), this.uncoveredGoals);
        }
        while (!this.isFinished() && this.getNumberOfCoveredGoals() < this.fitnessFunctions.size()) {
            this.evolve();
            this.notifyIteration();
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Time2MaxCoverage, this.budgetMonitor.getTime2MaxCoverage());
        this.notifySearchFinished();
    }

    private int getNumberOfCoveredGoals() {
        int n_covered_goals = this.archive.keySet().size();
        logger.debug("# Covered Goals = " + n_covered_goals);
        return n_covered_goals;
    }

    @Override
    public Set<FitnessFunction<T>> getCoveredGoals() {
        return this.archive.keySet();
    }

    private void updateArchive(T solution, FitnessFunction<T> covered) {
        TestChromosome tch = solution;
        tch.getTestCase().getCoveredGoals().add((TestFitnessFunction)covered);
        if (this.archive.containsKey(covered)) {
            TestChromosome existingSolution = (TestChromosome)this.archive.get(covered);
            if (((Chromosome)solution).compareSecondaryObjective((TestChromosome)existingSolution) < 0) {
                this.archive.put(covered, solution);
            }
        } else {
            this.archive.put(covered, solution);
            this.uncoveredGoals.remove(covered);
        }
    }

    @Override
    protected List<T> getArchive() {
        return new ArrayList<T>(new LinkedHashSet<T>(this.archive.values()));
    }

    @Override
    protected List<T> getFinalTestSuite() {
        if (this.getNumberOfCoveredGoals() == 0) {
            return this.getArchive();
        }
        if (this.archive.size() == 0) {
            if (this.population.size() > 0) {
                return Arrays.asList((Chromosome)this.population.get(this.population.size() - 1));
            }
            return this.getArchive();
        }
        List<T> final_tests = this.getArchive();
        List<T> tests = this.getNonDominatedSolutions(final_tests);
        return tests;
    }

    @Override
    public T getBestIndividual() {
        List<T> archiveContent = this.getArchive();
        if (archiveContent.isEmpty()) {
            return (T)new TestSuiteChromosome();
        }
        TestSuiteChromosome best = new TestSuiteChromosome();
        for (Chromosome test : archiveContent) {
            best.addTest((TestChromosome)test);
        }
        double coverage = (double)this.getNumberOfCoveredGoals() / (double)this.fitnessFunctions.size();
        for (TestSuiteFitnessFunction suiteFitness : this.suiteFitnesses) {
            best.setCoverage(suiteFitness, coverage);
            best.setFitness(suiteFitness, this.fitnessFunctions.size() - this.getNumberOfCoveredGoals());
        }
        return (T)best;
    }

    @Override
    protected double numberOfCoveredTargets() {
        return this.archive.keySet().size();
    }
}

