/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mosa.structural.BranchFitnessGraph;
import org.evosuite.ga.metaheuristics.mosa.structural.StructuralGoalManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchesManager<T extends Chromosome>
extends StructuralGoalManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(BranchesManager.class);
    protected BranchFitnessGraph<T, FitnessFunction<T>> graph;
    protected final Map<Integer, FitnessFunction<T>> branchCoverageTrueMap = new HashMap<Integer, FitnessFunction<T>>();
    protected final Map<Integer, FitnessFunction<T>> branchCoverageFalseMap = new HashMap<Integer, FitnessFunction<T>>();
    private final Map<String, FitnessFunction<T>> branchlessMethodCoverageMap = new HashMap<String, FitnessFunction<T>>();

    public BranchesManager(List<FitnessFunction<T>> fitnessFunctions) {
        super(fitnessFunctions);
        this.uncoveredGoals.addAll(fitnessFunctions);
        HashSet set = new HashSet();
        set.addAll(fitnessFunctions);
        this.graph = new BranchFitnessGraph(set);
        this.currentGoals.addAll(this.graph.getRootBranches());
        for (FitnessFunction<T> ff : fitnessFunctions) {
            BranchCoverageTestFitness goal = (BranchCoverageTestFitness)ff;
            if (goal.getBranch() != null && goal.getBranch().isInstrumented()) continue;
            if (goal.getBranch() == null) {
                this.branchlessMethodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), ff);
                continue;
            }
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), ff);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), ff);
        }
    }

    @Override
    public void calculateFitness(T c) {
        TestCase test = ((TestChromosome)c).getTestCase();
        ExecutionResult result = TestCaseExecutor.runTest(test);
        ((TestChromosome)c).setLastExecutionResult(result);
        ((Chromosome)c).setChanged(false);
        if (result.hasTimeout() || result.hasTestException()) {
            for (FitnessFunction f : this.currentGoals) {
                ((Chromosome)c).setFitness(f, Double.MAX_VALUE);
            }
            return;
        }
        HashSet<FitnessFunction> visitedStatements = new HashSet<FitnessFunction>(this.uncoveredGoals.size() * 2);
        LinkedList<FitnessFunction<T>> targets = new LinkedList<FitnessFunction<T>>();
        targets.addAll(this.currentGoals);
        while (targets.size() > 0) {
            FitnessFunction fitnessFunction = (FitnessFunction)targets.poll();
            int past_size = visitedStatements.size();
            visitedStatements.add(fitnessFunction);
            if (past_size == visitedStatements.size()) continue;
            double value = fitnessFunction.getFitness(c);
            if (value == 0.0) {
                this.updateCoveredGoals(fitnessFunction, c);
                for (FitnessFunction<T> child : this.graph.getStructuralChildren(fitnessFunction)) {
                    targets.addLast(child);
                }
                continue;
            }
            this.currentGoals.add(fitnessFunction);
        }
        this.currentGoals.removeAll(this.coveredGoals.keySet());
        for (Integer branchid : result.getTrace().getCoveredFalseBranches()) {
            FitnessFunction<T> branch = this.branchCoverageFalseMap.get(branchid);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        for (Integer branchid : result.getTrace().getCoveredTrueBranches()) {
            FitnessFunction<T> branch = this.branchCoverageTrueMap.get(branchid);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
        for (String method : result.getTrace().getCoveredBranchlessMethods()) {
            FitnessFunction<T> branch = this.branchlessMethodCoverageMap.get(method);
            if (branch == null) continue;
            this.updateCoveredGoals(branch, c);
        }
    }

    protected void debugStructuralDependencies(T c) {
        for (FitnessFunction fitnessFunction : this.uncoveredGoals) {
            double value = fitnessFunction.getFitness(c);
            if (!(value < 1.0) || this.currentGoals.contains(fitnessFunction) || this.coveredGoals.keySet().contains(fitnessFunction)) continue;
            logger.error("Branch {} has fitness {} but is not in the current goals", (Object)fitnessFunction.toString(), (Object)value);
        }
    }

    public BranchFitnessGraph<T, FitnessFunction<T>> getGraph() {
        return this.graph;
    }
}

