/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;

public abstract class StructuralGoalManager<T extends Chromosome> {
    protected Set<FitnessFunction<T>> uncoveredGoals;
    protected Set<FitnessFunction<T>> currentGoals;
    protected Map<FitnessFunction<T>, T> coveredGoals;
    protected Map<T, List<FitnessFunction<T>>> archive;

    protected StructuralGoalManager(List<FitnessFunction<T>> fitnessFunctions) {
        this.uncoveredGoals = new HashSet<FitnessFunction<T>>(fitnessFunctions.size());
        this.currentGoals = new HashSet<FitnessFunction<T>>(fitnessFunctions.size());
        this.coveredGoals = new HashMap<FitnessFunction<T>, T>(fitnessFunctions.size());
        this.archive = new HashMap<T, List<FitnessFunction<T>>>();
    }

    public abstract void calculateFitness(T var1);

    public Set<FitnessFunction<T>> getUncoveredGoals() {
        return this.uncoveredGoals;
    }

    public Set<FitnessFunction<T>> getCurrentGoals() {
        return this.currentGoals;
    }

    public Map<FitnessFunction<T>, T> getCoveredGoals() {
        return this.coveredGoals;
    }

    protected boolean isAlreadyCovered(FitnessFunction<T> target) {
        return this.uncoveredGoals.size() < this.coveredGoals.keySet().size() ? !this.uncoveredGoals.contains(target) : this.coveredGoals.keySet().contains(target);
    }

    protected void updateCoveredGoals(FitnessFunction<T> f, T tc) {
        TestChromosome tch = (TestChromosome)tc;
        tch.getTestCase().getCoveredGoals().add((TestFitnessFunction)f);
        boolean toArchive = false;
        Chromosome best = (Chromosome)this.coveredGoals.get(f);
        if (best == null) {
            toArchive = true;
            this.coveredGoals.put(f, tc);
            this.uncoveredGoals.remove(f);
            this.currentGoals.remove(f);
        } else {
            double bestSize = best.size();
            double size = ((Chromosome)tc).size();
            if (size < bestSize && size > 1.0) {
                toArchive = true;
                this.coveredGoals.put(f, tc);
                this.archive.get(best).remove(f);
                if (this.archive.get(best).size() == 0) {
                    this.archive.remove(best);
                }
            }
        }
        if (toArchive) {
            List<FitnessFunction<T>> coveredTargets = this.archive.get(tc);
            if (coveredTargets == null) {
                ArrayList<FitnessFunction<T>> list = new ArrayList<FitnessFunction<T>>();
                list.add(f);
                this.archive.put(tc, list);
            } else {
                coveredTargets.add(f);
            }
        }
    }

    public Set<T> getArchive() {
        return this.archive.keySet();
    }
}

