/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import java.util.ArrayList;
import java.util.Collections;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mulambda.AbstractMuLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuLambdaEA<T extends Chromosome>
extends AbstractMuLambda<T> {
    private static final long serialVersionUID = -1104094637643130537L;
    private static final Logger logger = LoggerFactory.getLogger(MuLambdaEA.class);

    public MuLambdaEA(ChromosomeFactory<T> factory, int mu, int lambda) {
        super(factory, mu, lambda);
    }

    @Override
    protected void evolve() {
        ArrayList<Chromosome> offspring = new ArrayList<Chromosome>(this.lambda);
        for (int i = 0; i < this.mu; ++i) {
            for (int j = 0; j < this.lambda / this.mu; ++j) {
                Chromosome t = ((Chromosome)this.population.get(i)).clone();
                do {
                    this.notifyMutation(t);
                    t.mutate();
                } while (!t.isChanged());
                offspring.add(t);
            }
        }
        for (Chromosome t : offspring) {
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(t);
                this.notifyEvaluation(t);
            }
        }
        if (this.getFitnessFunction().isMaximizationFunction()) {
            Collections.sort(offspring, Collections.reverseOrder());
        } else {
            Collections.sort(offspring);
        }
        for (int i = 0; i < this.population.size(); ++i) {
            logger.debug("replacing " + ((Chromosome)this.population.get(i)).getFitness() + " with " + ((Chromosome)offspring.get(i)).getFitness());
            this.population.set(i, offspring.get(i));
        }
    }
}

