/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.crossover;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.utils.Randomness;

public class SinglePointRelativeCrossOver
extends CrossOverFunction {
    private static final long serialVersionUID = -5320348525459502224L;

    @Override
    public void crossOver(Chromosome parent1, Chromosome parent2) throws ConstructionFailedException {
        if (parent1.size() < 2 || parent2.size() < 2) {
            return;
        }
        Chromosome t1 = parent1.clone();
        Chromosome t2 = parent2.clone();
        float splitPoint = Randomness.nextFloat();
        int pos1 = (int)Math.floor((float)(t1.size() - 1) * splitPoint) + 1;
        int pos2 = (int)Math.floor((float)(t2.size() - 1) * splitPoint) + 1;
        parent1.crossOver(t2, pos1, pos2);
        parent2.crossOver(t1, pos2, pos1);
    }
}

