/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.stoppingconditions;

import org.evosuite.Properties;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingConditionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTimeStoppingCondition
extends StoppingConditionImpl {
    private static final Logger logger = LoggerFactory.getLogger(GlobalTimeStoppingCondition.class);
    private static final long serialVersionUID = -4880914182984895075L;
    protected static long startTime = 0L;
    protected static long pauseTime = 0L;

    @Override
    public void searchStarted(GeneticAlgorithm<?> algorithm) {
        if (startTime == 0L) {
            this.reset();
        }
    }

    @Override
    public long getCurrentValue() {
        long current_time = System.currentTimeMillis();
        return (int)((current_time - startTime) / 1000L);
    }

    @Override
    public boolean isFinished() {
        long current_time = System.currentTimeMillis();
        if (Properties.GLOBAL_TIMEOUT != 0 && startTime != 0L && (current_time - startTime) / 1000L > (long)Properties.GLOBAL_TIMEOUT) {
            logger.info("Timeout reached");
        }
        return Properties.GLOBAL_TIMEOUT != 0 && startTime != 0L && (current_time - startTime) / 1000L > (long)Properties.GLOBAL_TIMEOUT;
    }

    @Override
    public void reset() {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
    }

    public void fullReset() {
        startTime = System.currentTimeMillis();
    }

    @Override
    public void setLimit(long limit) {
    }

    @Override
    public long getLimit() {
        return Properties.GLOBAL_TIMEOUT;
    }

    public static void forceReset() {
        startTime = 0L;
    }

    @Override
    public void forceCurrentValue(long value) {
        startTime = value;
    }

    public void pause() {
        pauseTime = System.currentTimeMillis();
    }

    public void resume() {
        startTime += System.currentTimeMillis() - pauseTime;
    }
}

