/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.evosuite.utils.LoggingUtils;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.StringEdgeNameProvider;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EvoSuiteGraph<V, E extends DefaultEdge> {
    private static Logger logger = LoggerFactory.getLogger(EvoSuiteGraph.class);
    private static int evoSuiteGraphs = 0;
    protected int graphId;
    protected DirectedGraph<V, E> graph;
    protected Class<E> edgeClass;
    ComponentAttributeProvider<V> vertexAttributeProvider = null;
    ComponentAttributeProvider<E> edgeAttributeProvider = null;

    protected EvoSuiteGraph(Class<E> edgeClass) {
        this.graph = new DefaultDirectedGraph(edgeClass);
        this.edgeClass = edgeClass;
        this.setId();
    }

    protected EvoSuiteGraph(DirectedGraph<V, E> graph, Class<E> edgeClass) {
        if (graph == null || edgeClass == null) {
            throw new IllegalArgumentException("null given");
        }
        this.graph = graph;
        this.edgeClass = edgeClass;
        this.setId();
    }

    private void setId() {
        this.graphId = ++evoSuiteGraphs;
    }

    public V getEdgeSource(E e) {
        if (!this.containsEdge(e)) {
            throw new IllegalArgumentException("edge not in graph");
        }
        return (V)this.graph.getEdgeSource(e);
    }

    public V getEdgeTarget(E e) {
        if (!this.containsEdge(e)) {
            throw new IllegalArgumentException("edge not in graph");
        }
        return (V)this.graph.getEdgeTarget(e);
    }

    public Set<E> outgoingEdgesOf(V node) {
        if (!this.containsVertex(node)) {
            throw new IllegalArgumentException("node not contained in this graph");
        }
        return new LinkedHashSet(this.graph.outgoingEdgesOf(node));
    }

    public Set<E> incomingEdgesOf(V node) {
        if (!this.containsVertex(node)) {
            throw new IllegalArgumentException("node not contained in this graph ");
        }
        return new LinkedHashSet(this.graph.incomingEdgesOf(node));
    }

    public Set<V> getChildren(V node) {
        if (!this.containsVertex(node)) {
            LoggingUtils.getEvoLogger().warn("getChildren call requests a node not contained in the current graph. Node: " + node);
            return null;
        }
        LinkedHashSet<V> r = new LinkedHashSet<V>();
        for (DefaultEdge e : this.outgoingEdgesOf(node)) {
            r.add(this.getEdgeTarget(e));
        }
        if (r.size() != this.outDegreeOf(node)) {
            throw new IllegalStateException("expect children count and size of set of all children of a graphs node to be equal");
        }
        return r;
    }

    public Set<V> getParents(V node) {
        if (!this.containsVertex(node)) {
            throw new IllegalArgumentException("node not contained in this graph");
        }
        LinkedHashSet<V> r = new LinkedHashSet<V>();
        for (DefaultEdge e : this.incomingEdgesOf(node)) {
            r.add(this.getEdgeSource(e));
        }
        if (r.size() != this.inDegreeOf(node)) {
            throw new IllegalStateException("expect parent count and size of set of all parents of a graphs node to be equal");
        }
        return r;
    }

    public Set<V> vertexSet() {
        return new LinkedHashSet(this.graph.vertexSet());
    }

    public Set<E> edgeSet() {
        return new LinkedHashSet(this.graph.edgeSet());
    }

    public V getSingleChild(V node) {
        if (node == null) {
            return null;
        }
        if (!this.graph.containsVertex(node)) {
            return null;
        }
        if (this.outDegreeOf(node) != 1) {
            return null;
        }
        Iterator<V> iterator = this.getChildren(node).iterator();
        if (iterator.hasNext()) {
            V r = iterator.next();
            return r;
        }
        return null;
    }

    protected void addVertices(EvoSuiteGraph<V, E> other) {
        this.addVertices(other.vertexSet());
    }

    protected void addVertices(Collection<V> vs) {
        if (vs == null) {
            throw new IllegalArgumentException("null given");
        }
        for (V v : vs) {
            if (this.addVertex(v)) continue;
            throw new IllegalArgumentException("unable to add all nodes in given collection: " + v.toString());
        }
    }

    protected boolean addVertex(V v) {
        return this.graph.addVertex(v);
    }

    protected E addEdge(V src, V target) {
        return (E)((DefaultEdge)this.graph.addEdge(src, target));
    }

    protected boolean addEdge(V src, V target, E e) {
        return this.graph.addEdge(src, target, e);
    }

    protected boolean redirectEdges(V from, V newStart, V newEnd) {
        if (!(this.containsVertex(from) && this.containsVertex(newStart) && this.containsVertex(newEnd))) {
            throw new IllegalArgumentException("expect all given nodes to be present in this graph");
        }
        if (!this.redirectIncomingEdges(from, newStart)) {
            return false;
        }
        return this.redirectOutgoingEdges(from, newEnd);
    }

    protected boolean redirectIncomingEdges(V oldNode, V newNode) {
        Set<E> incomings = this.incomingEdgesOf(oldNode);
        for (DefaultEdge incomingEdge : incomings) {
            if (this.redirectEdgeTarget(incomingEdge, newNode)) continue;
            return false;
        }
        return true;
    }

    protected boolean redirectOutgoingEdges(V oldNode, V newNode) {
        Set<E> outgoings = this.outgoingEdgesOf(oldNode);
        for (DefaultEdge outgoingEdge : outgoings) {
            if (this.redirectEdgeSource(outgoingEdge, newNode)) continue;
            return false;
        }
        return true;
    }

    protected boolean redirectEdgeTarget(E edge, V node) {
        if (!this.containsVertex(node) || !this.containsEdge(edge)) {
            throw new IllegalArgumentException("edge and node must be present in this graph");
        }
        Object edgeSource = this.graph.getEdgeSource(edge);
        if (!this.graph.removeEdge(edge)) {
            return false;
        }
        return this.addEdge(edgeSource, node, edge);
    }

    protected boolean redirectEdgeSource(E edge, V node) {
        if (!this.containsVertex(node) || !this.containsEdge(edge)) {
            throw new IllegalArgumentException("edge and node must be present in this graph");
        }
        Object edgeTarget = this.graph.getEdgeTarget(edge);
        if (!this.graph.removeEdge(edge)) {
            return false;
        }
        return this.addEdge(node, edgeTarget, edge);
    }

    public int vertexCount() {
        return this.graph.vertexSet().size();
    }

    public int edgeCount() {
        return this.graph.edgeSet().size();
    }

    public int outDegreeOf(V node) {
        if (node == null || !this.containsVertex(node)) {
            return -1;
        }
        return this.graph.outDegreeOf(node);
    }

    public int inDegreeOf(V node) {
        if (node == null || !this.containsVertex(node)) {
            return -1;
        }
        return this.graph.inDegreeOf(node);
    }

    public E getEdge(V v1, V v2) {
        return (E)((DefaultEdge)this.graph.getEdge(v1, v2));
    }

    public boolean containsVertex(V v) {
        return this.graph.containsVertex(v);
    }

    public boolean containsEdge(V v1, V v2) {
        return this.graph.containsEdge(v1, v2);
    }

    public boolean containsEdge(E e) {
        return this.graph.containsEdge(e);
    }

    public boolean isEmpty() {
        return this.graph.vertexSet().isEmpty();
    }

    public boolean isConnected() {
        if (this.vertexCount() < 2) {
            return true;
        }
        V start = this.getRandomVertex();
        Set<V> connectedToStart = this.determineConnectedVertices(start);
        return connectedToStart.size() == this.vertexSet().size();
    }

    public Set<V> determineEntryPoints() {
        LinkedHashSet<V> r = new LinkedHashSet<V>();
        for (V instruction : this.vertexSet()) {
            if (this.inDegreeOf(instruction) != 0) continue;
            r.add(instruction);
        }
        return r;
    }

    public Set<V> determineExitPoints() {
        LinkedHashSet<V> r = new LinkedHashSet<V>();
        for (V instruction : this.vertexSet()) {
            if (this.outDegreeOf(instruction) != 0) continue;
            r.add(instruction);
        }
        return r;
    }

    public Set<V> determineConnectedVertices(V v) {
        LinkedHashSet visited = new LinkedHashSet();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(v);
        while (!queue.isEmpty()) {
            Object current = queue.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            queue.addAll(this.getParents(current));
            queue.addAll(this.getChildren(current));
        }
        return visited;
    }

    public boolean hasNPartentsMChildren(V node, int n, int m) {
        if (node == null || !this.containsVertex(node)) {
            return false;
        }
        return this.inDegreeOf(node) == n && this.outDegreeOf(node) == m;
    }

    public Set<V> getIsolatedNodes() {
        LinkedHashSet r = new LinkedHashSet();
        for (Object node : this.graph.vertexSet()) {
            if (this.inDegreeOf(node) != 0 || this.outDegreeOf(node) != 0) continue;
            r.add(node);
        }
        return r;
    }

    public Set<V> getNodesWithoutChildren() {
        LinkedHashSet r = new LinkedHashSet();
        for (Object node : this.graph.vertexSet()) {
            if (this.outDegreeOf(node) != 0) continue;
            r.add(node);
        }
        return r;
    }

    public V getRandomVertex() {
        Iterator iterator = this.graph.vertexSet().iterator();
        if (iterator.hasNext()) {
            Object v = iterator.next();
            return (V)v;
        }
        return null;
    }

    public int getDistance(V v1, V v2) {
        DijkstraShortestPath d = new DijkstraShortestPath(this.graph, v1, v2);
        return (int)Math.round(d.getPathLength());
    }

    public boolean isDirectSuccessor(V v1, V v2) {
        return this.containsEdge(v1, v2) && this.inDegreeOf(v2) == 1;
    }

    public Set<V> determineBranches() {
        LinkedHashSet r = new LinkedHashSet();
        for (Object instruction : this.graph.vertexSet()) {
            if (this.outDegreeOf(instruction) <= 1) continue;
            r.add(instruction);
        }
        return r;
    }

    public Set<V> determineJoins() {
        LinkedHashSet<V> r = new LinkedHashSet<V>();
        for (V instruction : this.vertexSet()) {
            if (this.inDegreeOf(instruction) <= 1) continue;
            r.add(instruction);
        }
        return r;
    }

    protected DefaultDirectedGraph<V, E> computeReverseJGraph() {
        DefaultDirectedGraph r = new DefaultDirectedGraph(this.edgeClass);
        for (V v : this.vertexSet()) {
            if (r.addVertex(v)) continue;
            throw new IllegalStateException("internal error while adding vertices");
        }
        for (DefaultEdge e : this.edgeSet()) {
            V src = this.getEdgeSource(e);
            V target = this.getEdgeTarget(e);
            if (r.addEdge(target, src) != null) continue;
            throw new IllegalStateException("internal error while adding reverse edges");
        }
        return r;
    }

    public void toDot() {
        this.createGraphDirectory();
        String dotFileName = this.getGraphDirectory() + this.toFileString(this.getName()) + ".dot";
        this.toDot(dotFileName);
        this.createToPNGScript(dotFileName);
    }

    private String getGraphDirectory() {
        return "evosuite-graphs/" + this.dotSubFolder();
    }

    protected String dotSubFolder() {
        return "";
    }

    protected String toFileString(String name) {
        return name.replaceAll("\\(", "_").replaceAll("\\)", "_").replaceAll(";", "_").replaceAll("/", "_").replaceAll("<", "_").replaceAll(">", "_");
    }

    private void createGraphDirectory() {
        File graphDir = new File(this.getGraphDirectory());
        if (!graphDir.exists() && !graphDir.mkdirs()) {
            throw new IllegalStateException("unable to create directory " + this.getGraphDirectory());
        }
    }

    private void createToPNGScript(String filename) {
        File dotFile = new File(filename);
        assert (dotFile.exists() && !dotFile.isDirectory());
        try {
            String[] cmd = new String[]{"dot", "-Tpng", "-o" + dotFile.getAbsolutePath() + ".png", dotFile.getAbsolutePath()};
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            logger.error("Problem while generating a graph for a dotFile", (Throwable)e);
        }
    }

    public String getName() {
        return "EvoSuiteGraph_" + this.graphId;
    }

    public void registerVertexAttributeProvider(ComponentAttributeProvider<V> vertexAttributeProvider) {
        this.vertexAttributeProvider = vertexAttributeProvider;
    }

    public void registerEdgeAttributeProvider(ComponentAttributeProvider<E> edgeAttributeProvider) {
        this.edgeAttributeProvider = edgeAttributeProvider;
    }

    private void toDot(String filename) {
        try {
            FileWriter fstream = new FileWriter(filename);
            BufferedWriter out = new BufferedWriter(fstream);
            if (!this.graph.vertexSet().isEmpty()) {
                DOTExporter exporter = new DOTExporter((VertexNameProvider)new IntegerNameProvider(), (VertexNameProvider)new StringNameProvider(), (EdgeNameProvider)new StringEdgeNameProvider(), this.vertexAttributeProvider, this.edgeAttributeProvider);
                exporter.export((Writer)out, this.graph);
                logger.info("exportet " + this.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

