/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.ccfg;

import org.evosuite.graphs.ccfg.CCFGMethodReturnNode;
import org.evosuite.graphs.ccfg.CCFGNode;
import org.evosuite.graphs.cfg.BytecodeInstruction;

public class CCFGMethodCallNode
extends CCFGNode {
    private BytecodeInstruction callInstruction;
    private CCFGMethodReturnNode returnNode;

    public CCFGMethodCallNode(BytecodeInstruction callInstruction, CCFGMethodReturnNode returnNode) {
        this.callInstruction = callInstruction;
        this.returnNode = returnNode;
    }

    public String getMethod() {
        return this.callInstruction.getMethodName();
    }

    public String getCalledMethod() {
        return this.callInstruction.getCalledMethod();
    }

    public BytecodeInstruction getCallInstruction() {
        return this.callInstruction;
    }

    public CCFGMethodReturnNode getReturnNode() {
        return this.returnNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callInstruction == null ? 0 : this.callInstruction.hashCode());
        result = 31 * result + (this.returnNode == null ? 0 : this.returnNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CCFGMethodCallNode other = (CCFGMethodCallNode)obj;
        if (this.callInstruction == null ? other.callInstruction != null : !this.callInstruction.equals(other.callInstruction)) {
            return false;
        }
        return !(this.returnNode == null ? other.returnNode != null : !this.returnNode.equals(other.returnNode));
    }

    public String toString() {
        return "CALL from " + this.callInstruction.toString();
    }
}

