/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.ccfg;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.graphs.ccfg.CCFGCodeNode;
import org.evosuite.graphs.ccfg.CCFGFieldClassCallNode;
import org.evosuite.graphs.ccfg.CCFGFrameNode;
import org.evosuite.graphs.ccfg.CCFGMethodCallNode;
import org.evosuite.graphs.ccfg.CCFGMethodEntryNode;
import org.evosuite.graphs.ccfg.CCFGMethodExitNode;
import org.evosuite.graphs.ccfg.CCFGMethodReturnNode;
import org.evosuite.graphs.ccfg.CCFGNode;
import org.jgrapht.ext.ComponentAttributeProvider;

public class CCFGNodeAttributeProvider
implements ComponentAttributeProvider<CCFGNode> {
    public Map<String, String> getComponentAttributes(CCFGNode node) {
        HashMap<String, String> r = new HashMap<String, String>();
        if (node instanceof CCFGFrameNode) {
            r.put("shape", "diamond");
            r.put("style", "filled");
            r.put("fillcolor", "grey");
            r.put("fontcolor", "white");
            r.put("fontsize", "20");
        } else if (node instanceof CCFGMethodEntryNode) {
            r.put("style", "filled");
            r.put("shape", "triangle");
        } else if (node instanceof CCFGMethodExitNode) {
            r.put("style", "filled");
            r.put("shape", "invtriangle");
        } else if (node instanceof CCFGFieldClassCallNode) {
            String method = ((CCFGFieldClassCallNode)node).getCodeInstruction().getMethodName();
            String rgbColor = this.generateBColor(method);
            r.put("style", "filled");
            r.put("fillcolor", rgbColor);
            r.put("fontsize", "12");
            r.put("fontcolor", "white");
            r.put("shape", "hexagon");
        } else if (node instanceof CCFGCodeNode) {
            String method = ((CCFGCodeNode)node).getCodeInstruction().getMethodName();
            String rgbColor = this.generateSaturatedColor(method);
            r.put("style", "filled");
            r.put("fillcolor", rgbColor);
            r.put("fontsize", "12");
            r.put("fontcolor", "white");
        } else if (node instanceof CCFGMethodCallNode) {
            r.put("shape", "box");
            r.put("style", "filled");
            r.put("fillcolor", "green");
        } else if (node instanceof CCFGMethodReturnNode) {
            r.put("shape", "box");
            r.put("style", "filled");
            r.put("fillcolor", "red");
        }
        return r;
    }

    private String generateSaturatedColor(Object obj) {
        float h = Math.abs((float)obj.hashCode() / 2.1474836E9f);
        return h + ",0.85,0.55";
    }

    private String generateBColor(Object obj) {
        float h = Math.abs((float)obj.hashCode() / 2.1474836E9f);
        return h + ",0.85,0.95";
    }
}

