/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.graphs.cfg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.coverage.dataflow.DefUseFactory;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionIdComparator;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.graphs.cfg.ControlFlowEdge;
import org.evosuite.graphs.cfg.ControlFlowGraph;
import org.evosuite.utils.ReverseComparator;
import org.objectweb.asm.tree.LabelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawControlFlowGraph
extends ControlFlowGraph<BytecodeInstruction> {
    private static Logger logger = LoggerFactory.getLogger(RawControlFlowGraph.class);
    private final ClassLoader classLoader;

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public RawControlFlowGraph(ClassLoader classLoader, String className, String methodName, int access) {
        super(className, methodName, access);
        this.classLoader = classLoader;
        logger.info("Creating new RawCFG for " + className + "." + methodName + ": " + this.vertexCount());
    }

    @Override
    public boolean containsInstruction(BytecodeInstruction instruction) {
        return this.containsVertex(instruction);
    }

    @Override
    public BytecodeInstruction getInstruction(int instructionId) {
        for (BytecodeInstruction v : this.vertexSet()) {
            if (v.getInstructionId() != instructionId) continue;
            return v;
        }
        return null;
    }

    protected ControlFlowEdge addEdge(BytecodeInstruction src, BytecodeInstruction target, boolean isExceptionEdge) {
        logger.debug("Adding edge to RawCFG of " + this.className + "." + this.methodName + ": " + this.vertexCount());
        if (BranchPool.getInstance(this.classLoader).isKnownAsBranch(src)) {
            if (src.isBranch()) {
                return this.addBranchEdge(src, target, isExceptionEdge);
            }
            if (src.isSwitch()) {
                return this.addSwitchBranchEdge(src, target, isExceptionEdge);
            }
        }
        return this.addUnlabeledEdge(src, target, isExceptionEdge);
    }

    private ControlFlowEdge addUnlabeledEdge(BytecodeInstruction src, BytecodeInstruction target, boolean isExceptionEdge) {
        return this.internalAddEdge(src, target, new ControlFlowEdge(isExceptionEdge));
    }

    private ControlFlowEdge addBranchEdge(BytecodeInstruction src, BytecodeInstruction target, boolean isExceptionEdge) {
        boolean isJumping = !this.isNonJumpingEdge(src, target);
        ControlDependency cd = new ControlDependency(src.toBranch(), isJumping);
        ControlFlowEdge e = new ControlFlowEdge(cd, isExceptionEdge);
        return this.internalAddEdge(src, target, e);
    }

    private ControlFlowEdge addSwitchBranchEdge(BytecodeInstruction src, BytecodeInstruction target, boolean isExceptionEdge) {
        if (!target.isLabel()) {
            throw new IllegalStateException("expect control flow edges from switch statements to always target labelNodes");
        }
        LabelNode label = (LabelNode)target.getASMNode();
        List<Branch> switchCaseBranches = BranchPool.getInstance(this.classLoader).getBranchForLabel(label);
        if (switchCaseBranches == null) {
            logger.debug("not a switch case label: " + label.toString() + " " + target.toString());
            return this.internalAddEdge(src, target, new ControlFlowEdge(isExceptionEdge));
        }
        for (Branch switchCaseBranch : switchCaseBranches) {
            Set soFar = this.incomingEdgesOf(target);
            boolean handled = false;
            for (ControlFlowEdge old : soFar) {
                if (!switchCaseBranch.equals(old.getBranchInstruction())) continue;
                handled = true;
            }
            if (handled) continue;
            ControlDependency cd = new ControlDependency(switchCaseBranch, true);
            ControlFlowEdge e = new ControlFlowEdge(cd, isExceptionEdge);
            e = this.internalAddEdge(src, target, e);
        }
        return new ControlFlowEdge(isExceptionEdge);
    }

    private ControlFlowEdge internalAddEdge(BytecodeInstruction src, BytecodeInstruction target, ControlFlowEdge e) {
        if (!super.addEdge(src, target, e)) {
            logger.debug("unable to add edge from " + src.toString() + " to " + target.toString() + " into the rawCFG of " + this.getMethodName());
            e = (ControlFlowEdge)((Object)super.getEdge(src, target));
            if (e == null) {
                throw new IllegalStateException("internal graph error - completely unexpected");
            }
        }
        return e;
    }

    private boolean isNonJumpingEdge(BytecodeInstruction src, BytecodeInstruction dst) {
        return Math.abs(src.getInstructionId() - dst.getInstructionId()) == 1;
    }

    public BasicBlock determineBasicBlockFor(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        logger.debug("creating basic block for " + instruction.toString());
        ArrayList<BytecodeInstruction> blockNodes = new ArrayList<BytecodeInstruction>();
        blockNodes.add(instruction);
        HashSet<BytecodeInstruction> handledChildren = new HashSet<BytecodeInstruction>();
        HashSet<BytecodeInstruction> handledParents = new HashSet<BytecodeInstruction>();
        LinkedList<BytecodeInstruction> queue = new LinkedList<BytecodeInstruction>();
        queue.add(instruction);
        while (!queue.isEmpty()) {
            BytecodeInstruction current = (BytecodeInstruction)queue.poll();
            logger.debug("handling " + current.toString());
            if (this.outDegreeOf(current) == 1) {
                for (BytecodeInstruction child : this.getChildren(current)) {
                    if (blockNodes.contains(child) || handledChildren.contains(child)) continue;
                    handledChildren.add(child);
                    if (this.inDegreeOf(child) >= 2) continue;
                    blockNodes.add(blockNodes.indexOf(current) + 1, child);
                    logger.debug("  added child to queue: " + child.toString());
                    queue.add(child);
                }
            }
            if (this.inDegreeOf(current) != 1) continue;
            for (BytecodeInstruction parent : this.getParents(current)) {
                if (blockNodes.contains(parent) || handledParents.contains(parent)) continue;
                handledParents.add(parent);
                if (this.outDegreeOf(parent) >= 2) continue;
                blockNodes.add(blockNodes.indexOf(current), parent);
                logger.debug("  added parent to queue: " + parent.toString());
                queue.add(parent);
            }
        }
        BasicBlock r = new BasicBlock(this.classLoader, this.className, this.methodName, blockNodes);
        logger.debug("created nodeBlock: " + r.toString());
        return r;
    }

    @Override
    public BytecodeInstruction determineEntryPoint() {
        BytecodeInstruction noParent = (BytecodeInstruction)super.determineEntryPoint();
        if (noParent != null) {
            return noParent;
        }
        return this.getInstructionWithSmallestId();
    }

    @Override
    public Set<BytecodeInstruction> determineExitPoints() {
        Set<BytecodeInstruction> r = super.determineExitPoints();
        if (r.isEmpty()) {
            r.add(this.getInstructionWithBiggestId());
        }
        return r;
    }

    public BytecodeInstruction getInstructionWithSmallestId() {
        BytecodeInstruction r = null;
        for (BytecodeInstruction ins : this.vertexSet()) {
            if (r != null && r.getInstructionId() <= ins.getInstructionId()) continue;
            r = ins;
        }
        return r;
    }

    public BytecodeInstruction getInstructionWithBiggestId() {
        BytecodeInstruction r = null;
        for (BytecodeInstruction ins : this.vertexSet()) {
            if (r != null && r.getInstructionId() >= ins.getInstructionId()) continue;
            r = ins;
        }
        return r;
    }

    public int removeIsolatedNodes() {
        Set candidates = this.determineEntryPoints();
        int removed = 0;
        if (candidates.size() > 1) {
            for (BytecodeInstruction instruction : candidates) {
                if (this.outDegreeOf(instruction) != 0 || !this.graph.removeVertex((Object)instruction)) continue;
                ++removed;
                BytecodeInstructionPool.getInstance(this.classLoader).forgetInstruction(instruction);
            }
        }
        return removed;
    }

    public Set<BytecodeInstruction> getPreviousInstructionsInMethod(BytecodeInstruction v) {
        HashSet<BytecodeInstruction> visited = new HashSet<BytecodeInstruction>();
        PriorityQueue<BytecodeInstruction> queue = new PriorityQueue<BytecodeInstruction>(this.graph.vertexSet().size(), new BytecodeInstructionIdComparator());
        queue.add(v);
        while (queue.peek() != null) {
            BytecodeInstruction current = queue.poll();
            if (visited.contains(current)) continue;
            Set incomingEdges = this.graph.incomingEdgesOf((Object)current);
            for (ControlFlowEdge incomingEdge : incomingEdges) {
                BytecodeInstruction source = (BytecodeInstruction)this.graph.getEdgeSource((Object)incomingEdge);
                if (source.getInstructionId() >= current.getInstructionId()) continue;
                queue.add(source);
            }
            visited.add(current);
        }
        return visited;
    }

    public Set<BytecodeInstruction> getLaterInstructionsInMethod(BytecodeInstruction v) {
        HashSet<BytecodeInstruction> visited = new HashSet<BytecodeInstruction>();
        ReverseComparator<BytecodeInstruction> reverseComp = new ReverseComparator<BytecodeInstruction>(new BytecodeInstructionIdComparator());
        PriorityQueue<BytecodeInstruction> queue = new PriorityQueue<BytecodeInstruction>(this.graph.vertexSet().size(), reverseComp);
        queue.add(v);
        while (queue.peek() != null) {
            BytecodeInstruction current = queue.poll();
            if (visited.contains(current)) continue;
            Set outgoingEdges = this.graph.outgoingEdgesOf((Object)current);
            for (ControlFlowEdge outgoingEdge : outgoingEdges) {
                BytecodeInstruction target = (BytecodeInstruction)this.graph.getEdgeTarget((Object)outgoingEdge);
                if (target.getInstructionId() < current.getInstructionId()) continue;
                queue.add(target);
            }
            visited.add(current);
        }
        return visited;
    }

    public Set<Use> getUsesForDef(Definition def) {
        if (!this.graph.containsVertex((Object)def)) {
            throw new IllegalArgumentException("unknown Definition");
        }
        return this.getUsesForDef(def, def, new HashSet<BytecodeInstruction>());
    }

    private Set<Use> getUsesForDef(Definition targetDef, BytecodeInstruction currentInstruction, Set<BytecodeInstruction> handled) {
        if (!this.graph.containsVertex((Object)currentInstruction)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        HashSet<Use> r = new HashSet<Use>();
        if (handled.contains(currentInstruction)) {
            return r;
        }
        handled.add(currentInstruction);
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)currentInstruction);
        for (ControlFlowEdge e : outgoingEdges) {
            BytecodeInstruction edgeTarget = (BytecodeInstruction)this.graph.getEdgeTarget((Object)e);
            if (targetDef.canBeActiveFor(edgeTarget)) {
                r.add(DefUseFactory.makeUse(edgeTarget));
            }
            if (this.canOverwriteDU(targetDef, edgeTarget)) continue;
            r.addAll(this.getUsesForDef(targetDef, edgeTarget, handled));
        }
        return r;
    }

    public boolean hasDefClearPathToMethodExit(Definition duVertex) {
        if (!this.graph.containsVertex((Object)duVertex)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        if (duVertex.isLocalDU()) {
            return false;
        }
        return this.hasDefClearPathToMethodExit(duVertex, duVertex, new HashSet<BytecodeInstruction>());
    }

    public boolean hasDefClearPathFromMethodEntry(Use duVertex) {
        if (!this.graph.containsVertex((Object)duVertex)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        if (duVertex.isLocalDU()) {
            return false;
        }
        return this.hasDefClearPathFromMethodEntry(duVertex, duVertex, new HashSet<BytecodeInstruction>());
    }

    private boolean hasDefClearPathToMethodExit(Definition targetDefUse, BytecodeInstruction currentVertex, Set<BytecodeInstruction> handled) {
        if (!this.graph.containsVertex((Object)currentVertex)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        if (handled.contains(currentVertex)) {
            return false;
        }
        handled.add(currentVertex);
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)currentVertex);
        if (outgoingEdges.size() == 0) {
            return true;
        }
        for (ControlFlowEdge e : outgoingEdges) {
            BytecodeInstruction edgeTarget = (BytecodeInstruction)this.graph.getEdgeTarget((Object)e);
            if (this.canOverwriteDU(targetDefUse, edgeTarget) || !this.hasDefClearPathToMethodExit(targetDefUse, edgeTarget, handled)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefClearPathFromMethodEntry(Use targetDefUse, BytecodeInstruction currentVertex, Set<BytecodeInstruction> handled) {
        if (!this.graph.containsVertex((Object)currentVertex)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        if (handled.contains(currentVertex)) {
            return false;
        }
        handled.add(currentVertex);
        Set incomingEdges = this.graph.incomingEdgesOf((Object)currentVertex);
        if (incomingEdges.size() == 0) {
            return true;
        }
        for (ControlFlowEdge e : incomingEdges) {
            BytecodeInstruction edgeStart = (BytecodeInstruction)this.graph.getEdgeSource((Object)e);
            if (this.canOverwriteDU(targetDefUse, edgeStart, new HashSet<String>()) || !this.hasDefClearPathFromMethodEntry(targetDefUse, edgeStart, handled)) continue;
            return true;
        }
        return false;
    }

    private boolean callsOverwritingMethod(DefUse targetDefUse, BytecodeInstruction edgeTarget, Set<String> handle) {
        if (this.canBeOverwritingMethod(targetDefUse, edgeTarget)) {
            RawControlFlowGraph calledGraph = edgeTarget.getCalledCFG();
            if (calledGraph == null) {
                logger.debug("expected cfg to exist for: " + edgeTarget.getCalledMethod() + " ... abstract method?");
                return false;
            }
            if (!calledGraph.hasDefClearPath(targetDefUse, handle)) {
                return true;
            }
        }
        return false;
    }

    public boolean hasDefClearPath(DefUse targetDU, Set<String> handle) {
        BytecodeInstruction entry = this.determineEntryPoint();
        return this.hasDefClearPath(targetDU, entry, handle);
    }

    private boolean hasDefClearPath(DefUse targetDU, BytecodeInstruction currentVertex, Set<String> handle) {
        if (!this.graph.containsVertex((Object)currentVertex)) {
            throw new IllegalArgumentException("vertex not in graph");
        }
        handle.add(this.methodName);
        String targetVariable = targetDU.getVariableName();
        if (currentVertex.isDefinitionForVariable(targetVariable)) {
            return false;
        }
        Set outgoingEdges = this.graph.outgoingEdgesOf((Object)currentVertex);
        if (outgoingEdges.size() == 0) {
            return true;
        }
        for (ControlFlowEdge e : outgoingEdges) {
            BytecodeInstruction edgeTarget = (BytecodeInstruction)this.graph.getEdgeTarget((Object)e);
            if (this.canBeOverwritingMethod(targetDU, edgeTarget) && !handle.contains(edgeTarget.getCalledMethod()) && this.canOverwriteDU(targetDU, edgeTarget, handle) || !this.hasDefClearPath(targetDU, edgeTarget, handle)) continue;
            return true;
        }
        return false;
    }

    private boolean canOverwriteDU(Definition targetDefUse, BytecodeInstruction edgeTarget) {
        return this.canOverwriteDU(targetDefUse, edgeTarget, new HashSet<String>());
    }

    private boolean canOverwriteDU(DefUse targetDefUse, BytecodeInstruction edgeTarget, Set<String> handle) {
        if (targetDefUse.canBecomeActiveDefinition(edgeTarget)) {
            return true;
        }
        return this.callsOverwritingMethod(targetDefUse, edgeTarget, handle);
    }

    private boolean canBeOverwritingMethod(DefUse targetDefUse, BytecodeInstruction edgeTarget) {
        return targetDefUse.isFieldDU() && edgeTarget.isMethodCallForClass(targetDefUse.getClassName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (ControlFlowEdge e : this.graph.edgeSet()) {
            sb.append(this.graph.getEdgeSource((Object)e) + " -> " + this.graph.getEdgeTarget((Object)e));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getCFGType() {
        return "RCFG";
    }

    public List<BytecodeInstruction> determineMethodCalls() {
        ArrayList<BytecodeInstruction> calls = new ArrayList<BytecodeInstruction>();
        for (BytecodeInstruction ins : this.graph.vertexSet()) {
            if (!ins.isMethodCall()) continue;
            calls.add(ins);
        }
        return calls;
    }

    public List<BytecodeInstruction> determineMethodCallsToOwnClass() {
        ArrayList<BytecodeInstruction> calls = new ArrayList<BytecodeInstruction>();
        for (BytecodeInstruction ins : this.determineMethodCalls()) {
            if (!ins.isMethodCallForClass(this.className) || GraphPool.getInstance(this.classLoader).getRawCFG(this.className, ins.getCalledMethod()) == null) continue;
            calls.add(ins);
        }
        return calls;
    }

    @Override
    public boolean addVertex(BytecodeInstruction ins) {
        return super.addVertex(ins);
    }
}

