/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.PrintWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.evosuite.Properties;
import org.evosuite.classpath.ResourceList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class PrintBytecodeTransformer
implements ClassFileTransformer {
    private static String target_class = Properties.TARGET_CLASS;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className != null) {
            try {
                ClassWriter writer;
                String classNameWithDots = ResourceList.getClassNameFromResourcePath(className);
                ClassReader reader = new ClassReader(classfileBuffer);
                ClassWriter cv = writer = new ClassWriter(1);
                if (classNameWithDots.equals(target_class) || classNameWithDots.startsWith(target_class + "$")) {
                    cv = new TraceClassVisitor((ClassVisitor)cv, new PrintWriter(System.out));
                }
                reader.accept((ClassVisitor)cv, 4);
                classfileBuffer = writer.toByteArray();
                return classfileBuffer;
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
        return classfileBuffer;
    }
}

