/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.evosuite.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationStatistics {
    private static Logger logger = LoggerFactory.getLogger(TransformationStatistics.class);
    public static int transformedBooleanComparison = 0;
    public static int insertedGet = 0;
    public static int insertedPushInt0 = 0;
    public static int insertedPushInt1 = 0;
    public static int insertedPushIntRef = 0;
    public static int insertedPushIntNull = 0;
    public static int transformedComparison = 0;
    public static int transformedImplicitElse = 0;
    public static int transformedInstanceOf = 0;
    public static int transformedBooleanReturn = 0;
    public static int transformedBooleanParameter = 0;
    public static int transformedBooleanField = 0;
    public static int transformedBackToBooleanParameter = 0;
    public static int transformedBackToBooleanField = 0;
    public static int untransformableMethod = 0;
    public static int transformedStringComparison = 0;
    public static int transformedContainerComparison = 0;
    public static int transformedBitwise = 0;

    public static void reset() {
        transformedBooleanComparison = 0;
        insertedGet = 0;
        insertedPushInt0 = 0;
        insertedPushInt1 = 0;
        insertedPushIntRef = 0;
        insertedPushIntNull = 0;
        transformedComparison = 0;
        transformedImplicitElse = 0;
        transformedInstanceOf = 0;
        transformedBooleanReturn = 0;
        transformedBooleanParameter = 0;
        untransformableMethod = 0;
        transformedStringComparison = 0;
        transformedContainerComparison = 0;
    }

    public static void transformedBooleanComparison() {
        ++transformedBooleanComparison;
    }

    public static void insertedGet() {
        ++insertedGet;
    }

    public static void insertPush(int opcode) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                ++insertedPushInt0;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                ++insertedPushInt1;
                break;
            }
            case 198: 
            case 199: {
                ++insertedPushIntRef;
                break;
            }
            case 165: 
            case 166: {
                ++insertedPushIntNull;
                break;
            }
        }
    }

    public static void transformedComparison() {
        ++transformedComparison;
    }

    public static void transformedImplicitElse() {
        ++transformedImplicitElse;
    }

    public static void transformInstanceOf() {
        ++transformedInstanceOf;
    }

    public static void transformBooleanReturnValue() {
        ++transformedBooleanReturn;
    }

    public static void transformBooleanParameter() {
        ++transformedBooleanParameter;
    }

    public static void transformBooleanField() {
        ++transformedBooleanField;
    }

    public static void transformBackToBooleanParameter() {
        ++transformedBackToBooleanParameter;
    }

    public static void transformBackToBooleanField() {
        ++transformedBackToBooleanField;
    }

    public static void foundUntransformableMethod() {
        ++untransformableMethod;
    }

    public static void transformedStringComparison() {
        ++transformedStringComparison;
    }

    public static void transformedContainerComparison() {
        ++transformedContainerComparison;
    }

    public static void transformedBitwise() {
        ++transformedBitwise;
    }

    public static void writeStatistics(String className) {
        try {
            String filename = Properties.REPORT_DIR + "/transformation.csv";
            File logfile = new File(filename);
            boolean needHeader = !logfile.exists();
            BufferedWriter out = new BufferedWriter(new FileWriter(logfile, true));
            if (needHeader) {
                out.write("ClassName,BooleanComparison,Get,Push0,Push1,PushRef,PushNull,Comparison,ImplicitElse,InstanceOf,BooleanReturn,BooleanParameter,BooleanField,BackToBooleanParameter,BackToBooleanField,UntransformableMethod,StringComparison,ContainerComparison\n");
            }
            out.write(className);
            out.write(",");
            out.write(transformedBooleanComparison + ",");
            out.write(insertedGet + ",");
            out.write(insertedPushInt0 + ",");
            out.write(insertedPushInt1 + ",");
            out.write(insertedPushIntRef + ",");
            out.write(insertedPushIntNull + ",");
            out.write(transformedComparison + ",");
            out.write(transformedImplicitElse + ",");
            out.write(transformedInstanceOf + ",");
            out.write(transformedBooleanReturn + ",");
            out.write(transformedBooleanParameter + ",");
            out.write(transformedBooleanField + ",");
            out.write(transformedBackToBooleanParameter + ",");
            out.write(transformedBackToBooleanField + ",");
            out.write(transformedStringComparison + ",");
            out.write(transformedContainerComparison + ",");
            out.write("\n");
            out.close();
        }
        catch (IOException e) {
            logger.info("Exception while writing CSV data: " + e);
        }
    }
}

