/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.coverage;

import java.util.List;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.instrumentation.coverage.MethodInstrumentation;
import org.evosuite.runtime.instrumentation.AnnotatedLabel;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchInstrumentation
implements MethodInstrumentation {
    protected static final Logger logger = LoggerFactory.getLogger(BranchInstrumentation.class);
    private static final String EXECUTION_TRACER = Type.getInternalName(ExecutionTracer.class);
    private ClassLoader classLoader;

    @Override
    public void analyze(ClassLoader classLoader, MethodNode mn, String className, String methodName, int access) {
        this.classLoader = classLoader;
        RawControlFlowGraph graph = GraphPool.getInstance(classLoader).getRawCFG(className, methodName);
        for (AbstractInsnNode in : mn.instructions) {
            for (BytecodeInstruction v : graph.vertexSet()) {
                if (!in.equals(v.getASMNode())) continue;
                if (v.isBranch()) {
                    AnnotatedLabel aLabel;
                    LabelNode label;
                    if (in.getPrevious() instanceof LabelNode && (label = (LabelNode)in.getPrevious()).getLabel() instanceof AnnotatedLabel && (aLabel = (AnnotatedLabel)label.getLabel()).isStartTag()) {
                        if (aLabel.shouldIgnore()) continue;
                        logger.debug("Found artificial branch: " + v);
                        Branch b = BranchPool.getInstance(classLoader).getBranchForInstruction(v);
                        b.setInstrumented(true);
                    }
                    mn.instructions.insertBefore(v.getASMNode(), this.getInstrumentation(v));
                    continue;
                }
                if (!v.isSwitch()) continue;
                mn.instructions.insertBefore(v.getASMNode(), this.getSwitchInstrumentation(v, mn, className, methodName));
            }
        }
        mn.maxStack += 4;
    }

    protected InsnList getInstrumentation(BytecodeInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("null given");
        }
        if (!instruction.isActualBranch()) {
            throw new IllegalArgumentException("branch instruction expected");
        }
        if (!BranchPool.getInstance(this.classLoader).isKnownAsNormalBranchInstruction(instruction)) {
            throw new IllegalArgumentException("expect given instruction to be known by the BranchPool as a normal branch instruction");
        }
        int opcode = instruction.getASMNode().getOpcode();
        int instructionId = instruction.getInstructionId();
        int branchId = BranchPool.getInstance(this.classLoader).getActualBranchIdForNormalBranchInstruction(instruction);
        if (branchId < 0) {
            throw new IllegalStateException("expect BranchPool to know branchId for all branch instructions");
        }
        InsnList instrumentation = new InsnList();
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)opcode));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)branchId));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)instructionId));
                instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(IIII)V", false));
                logger.debug("Adding passedBranch val=?, opcode=" + opcode + ", branch=" + branchId + ", bytecode_id=" + instructionId);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                instrumentation.add((AbstractInsnNode)new InsnNode(92));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)opcode));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)branchId));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)instructionId));
                instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(IIIII)V", false));
                break;
            }
            case 165: 
            case 166: {
                instrumentation.add((AbstractInsnNode)new InsnNode(92));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)opcode));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)branchId));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)instructionId));
                instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(Ljava/lang/Object;Ljava/lang/Object;III)V", false));
                break;
            }
            case 198: 
            case 199: {
                instrumentation.add((AbstractInsnNode)new InsnNode(89));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)opcode));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)branchId));
                instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)instructionId));
                instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(Ljava/lang/Object;III)V", false));
            }
        }
        return instrumentation;
    }

    protected InsnList getSwitchInstrumentation(BytecodeInstruction v, MethodNode mn, String className, String methodName) {
        InsnList instrumentation = new InsnList();
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        this.addInstrumentationForDefaultSwitchCase(v, instrumentation);
        this.addInstrumentationForSwitchCases(v, instrumentation, className, methodName);
        return instrumentation;
    }

    protected void addInstrumentationForSwitchCases(BytecodeInstruction v, InsnList instrumentation, String className, String methodName) {
        if (!v.isSwitch()) {
            throw new IllegalArgumentException("switch instruction expected");
        }
        List<Branch> caseBranches = BranchPool.getInstance(this.classLoader).getCaseBranchesForSwitch(v);
        if (caseBranches == null || caseBranches.isEmpty()) {
            throw new IllegalStateException("expect BranchPool to know at least one Branch for each switch instruction");
        }
        for (Branch targetCaseBranch : caseBranches) {
            if (targetCaseBranch.isDefaultCase()) continue;
            Integer targetCaseValue = targetCaseBranch.getTargetCaseValue();
            Integer targetCaseBranchId = targetCaseBranch.getActualBranchId();
            instrumentation.add((AbstractInsnNode)new InsnNode(89));
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)targetCaseValue));
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)159));
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)targetCaseBranchId));
            instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)v.getInstructionId()));
            instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(IIIII)V", false));
        }
    }

    protected void addInstrumentationForDefaultSwitchCase(BytecodeInstruction v, InsnList instrumentation) {
        if (v.isTableSwitch()) {
            this.addInstrumentationForDefaultTableswitchCase(v, instrumentation);
        }
        if (v.isLookupSwitch()) {
            this.addInstrumentationForDefaultLookupswitchCase(v, instrumentation);
        }
    }

    protected void addInstrumentationForDefaultTableswitchCase(BytecodeInstruction v, InsnList instrumentation) {
        if (!v.isTableSwitch()) {
            throw new IllegalArgumentException("tableswitch instruction expected");
        }
        TableSwitchInsnNode toInstrument = (TableSwitchInsnNode)v.getASMNode();
        LabelNode caseLabel = new LabelNode();
        LabelNode defaultLabel = new LabelNode();
        LabelNode endLabel = new LabelNode();
        int keySize = toInstrument.max - toInstrument.min + 1;
        LabelNode[] caseLabels = new LabelNode[keySize];
        for (int i = 0; i < keySize; ++i) {
            caseLabels[i] = caseLabel;
        }
        TableSwitchInsnNode mySwitch = new TableSwitchInsnNode(toInstrument.min, toInstrument.max, defaultLabel, caseLabels);
        this.addDefaultCaseInstrumentation(v, instrumentation, (AbstractInsnNode)mySwitch, defaultLabel, caseLabel, endLabel);
    }

    protected void addInstrumentationForDefaultLookupswitchCase(BytecodeInstruction v, InsnList instrumentation) {
        if (!v.isLookupSwitch()) {
            throw new IllegalArgumentException("lookup switch expected");
        }
        LookupSwitchInsnNode toInstrument = (LookupSwitchInsnNode)v.getASMNode();
        LabelNode caseLabel = new LabelNode();
        LabelNode defaultLabel = new LabelNode();
        LabelNode endLabel = new LabelNode();
        int keySize = toInstrument.keys.size();
        int[] keys = new int[keySize];
        LabelNode[] labels = new LabelNode[keySize];
        for (int i = 0; i < keySize; ++i) {
            keys[i] = (Integer)toInstrument.keys.get(i);
            labels[i] = caseLabel;
        }
        LookupSwitchInsnNode myLookup = new LookupSwitchInsnNode(defaultLabel, keys, labels);
        this.addDefaultCaseInstrumentation(v, instrumentation, (AbstractInsnNode)myLookup, defaultLabel, caseLabel, endLabel);
    }

    protected void addDefaultCaseInstrumentation(BytecodeInstruction v, InsnList instrumentation, AbstractInsnNode mySwitch, LabelNode defaultLabel, LabelNode caseLabel, LabelNode endLabel) {
        int defaultCaseBranchId = BranchPool.getInstance(this.classLoader).getDefaultBranchForSwitch(v).getActualBranchId();
        instrumentation.add((AbstractInsnNode)new InsnNode(89));
        instrumentation.add(mySwitch);
        instrumentation.add((AbstractInsnNode)caseLabel);
        this.addDefaultCaseNotCoveredCall(v, instrumentation, defaultCaseBranchId);
        instrumentation.add((AbstractInsnNode)new JumpInsnNode(167, endLabel));
        instrumentation.add((AbstractInsnNode)defaultLabel);
        this.addDefaultCaseCoveredCall(v, instrumentation, defaultCaseBranchId);
        instrumentation.add((AbstractInsnNode)endLabel);
    }

    protected void addDefaultCaseCoveredCall(BytecodeInstruction v, InsnList instrumentation, int defaultCaseBranchId) {
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)0));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)153));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)defaultCaseBranchId));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)v.getInstructionId()));
        instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(IIII)V", false));
    }

    protected void addDefaultCaseNotCoveredCall(BytecodeInstruction v, InsnList instrumentation, int defaultCaseBranchId) {
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)0));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)154));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)defaultCaseBranchId));
        instrumentation.add((AbstractInsnNode)new LdcInsnNode((Object)v.getInstructionId()));
        instrumentation.add((AbstractInsnNode)new MethodInsnNode(184, EXECUTION_TRACER, "passedBranch", "(IIII)V", false));
    }

    @Override
    public boolean executeOnExcludedMethods() {
        return false;
    }

    @Override
    public boolean executeOnMainMethod() {
        return false;
    }
}

