/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.error;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.evosuite.instrumentation.error.ErrorBranchInstrumenter;
import org.evosuite.instrumentation.error.ErrorConditionMethodAdapter;
import org.objectweb.asm.Type;

public class ListInstrumentation
extends ErrorBranchInstrumenter {
    private static final String LISTNAME = LinkedList.class.getCanonicalName().replace('.', '/');
    private final List<String> indexListMethods = Arrays.asList("get", "set", "add", "remove", "listIterator", "addAll");

    public ListInstrumentation(ErrorConditionMethodAdapter mv) {
        super(mv);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (owner.equals(LISTNAME) && this.indexListMethods.contains(name)) {
            Type[] args = Type.getArgumentTypes((String)desc);
            if (args.length == 0) {
                return;
            }
            if (!args[0].equals((Object)Type.INT_TYPE)) {
                return;
            }
            Map<Integer, Integer> tempVariables = this.getMethodCallee(desc);
            this.tagBranchStart();
            this.mv.visitMethodInsn(182, LISTNAME, "size", "()I", false);
            this.mv.loadLocal(tempVariables.get(0));
            this.insertBranch(163, "java/lang/IndexOutOfBoundsException");
            this.mv.loadLocal(tempVariables.get(0));
            this.insertBranch(156, "java/lang/IndexOutOfBoundsException");
            this.tagBranchEnd();
            this.restoreMethodParameters(tempVariables, desc);
        }
    }
}

