/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.mutation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.instrumentation.BooleanValueInterpreter;
import org.evosuite.instrumentation.mutation.MutationOperator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceComparisonOperator
implements MutationOperator {
    private static final Logger logger = LoggerFactory.getLogger(ReplaceComparisonOperator.class);
    public static final String NAME = "ReplaceComparisonOperator";
    private static Set<Integer> opcodesReference = new HashSet<Integer>();
    private static Set<Integer> opcodesNull = new HashSet<Integer>();
    private static Set<Integer> opcodesInt = new HashSet<Integer>();
    private static Set<Integer> opcodesIntInt = new HashSet<Integer>();
    private static final int TRUE = -1;
    private static final int FALSE = -2;

    private String getOp(int opcode) {
        switch (opcode) {
            case 153: 
            case 159: 
            case 165: {
                return "==";
            }
            case 154: 
            case 160: 
            case 166: {
                return "!=";
            }
            case 155: 
            case 161: {
                return "<";
            }
            case 158: 
            case 164: {
                return "<=";
            }
            case 157: 
            case 163: {
                return ">";
            }
            case 156: 
            case 162: {
                return ">=";
            }
            case 198: {
                return "= null";
            }
            case 199: {
                return "!= null";
            }
        }
        throw new RuntimeException("Unknown opcode: " + opcode);
    }

    @Override
    public List<Mutation> apply(MethodNode mn, String className, String methodName, BytecodeInstruction instruction, Frame frame) {
        JumpInsnNode node = (JumpInsnNode)instruction.getASMNode();
        LinkedList<Mutation> mutations = new LinkedList<Mutation>();
        LabelNode target = node.label;
        boolean isBoolean = frame.getStack(frame.getStackSize() - 1) == BooleanValueInterpreter.BOOLEAN_VALUE;
        for (Integer op : this.getOperators(node.getOpcode(), isBoolean)) {
            Mutation mutationObject;
            InsnList mutation;
            logger.debug("Adding replacement " + op);
            if (op >= 0) {
                mutation = new JumpInsnNode(op.intValue(), target);
                mutationObject = MutationPool.addMutation(className, methodName, "ReplaceComparisonOperator " + this.getOp(node.getOpcode()) + " -> " + this.getOp(op), instruction, (AbstractInsnNode)mutation, this.getInfectionDistance(node.getOpcode(), op));
                mutations.add(mutationObject);
                continue;
            }
            mutation = new InsnList();
            if (opcodesInt.contains(node.getOpcode())) {
                mutation.add((AbstractInsnNode)new InsnNode(87));
            } else {
                mutation.add((AbstractInsnNode)new InsnNode(88));
            }
            if (op == -1) {
                mutation.add((AbstractInsnNode)new LdcInsnNode((Object)1));
            } else {
                mutation.add((AbstractInsnNode)new LdcInsnNode((Object)0));
            }
            mutation.add((AbstractInsnNode)new JumpInsnNode(154, target));
            mutationObject = MutationPool.addMutation(className, methodName, "ReplaceComparisonOperator " + this.getOp(node.getOpcode()) + " -> " + op, instruction, mutation, this.getInfectionDistance(node.getOpcode(), op));
            mutations.add(mutationObject);
        }
        return mutations;
    }

    public InsnList getInfectionDistance(int opcodeOrig, int opcodeNew) {
        InsnList distance = new InsnList();
        switch (opcodeOrig) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                distance.add((AbstractInsnNode)new InsnNode(92));
                distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
                distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
                distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceComparisonOperator.class), "getInfectionDistance", "(IIII)D", false));
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                distance.add((AbstractInsnNode)new InsnNode(89));
                distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeOrig));
                distance.add((AbstractInsnNode)new LdcInsnNode((Object)opcodeNew));
                distance.add((AbstractInsnNode)new MethodInsnNode(184, PackageInfo.getNameWithSlash(ReplaceComparisonOperator.class), "getInfectionDistance", "(III)D", false));
                break;
            }
            default: {
                distance.add((AbstractInsnNode)new LdcInsnNode((Object)0.0));
            }
        }
        return distance;
    }

    public static double getInfectionDistance(int left, int right, int opcodeOrig, int opcodeNew) {
        long val = (long)left - (long)right;
        switch (opcodeOrig) {
            case 161: {
                switch (opcodeNew) {
                    case 164: {
                        return Math.abs(val);
                    }
                    case 159: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case 163: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 162: {
                        return 0.0;
                    }
                    case 160: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case -1: {
                        return val < 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val < 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 164: {
                switch (opcodeNew) {
                    case 161: {
                        return Math.abs(val);
                    }
                    case 159: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 162: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 163: {
                        return 0.0;
                    }
                    case 160: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case -1: {
                        return val <= 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val <= 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 163: {
                switch (opcodeNew) {
                    case 162: {
                        return Math.abs(val);
                    }
                    case 159: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 161: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 164: {
                        return 0.0;
                    }
                    case 160: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case -1: {
                        return val > 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val > 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 162: {
                switch (opcodeNew) {
                    case 163: {
                        return Math.abs(val);
                    }
                    case 159: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case 164: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 161: {
                        return 0.0;
                    }
                    case 160: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case -1: {
                        return val >= 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val >= 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 159: {
                switch (opcodeNew) {
                    case 161: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case 163: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 160: {
                        return 0.0;
                    }
                    case 164: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 162: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case -1: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val == 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 160: {
                switch (opcodeNew) {
                    case 159: {
                        return 0.0;
                    }
                    case 161: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case 164: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 163: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 162: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case -1: {
                        return val != 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val != 0L ? 0.0 : 1.0;
                    }
                }
            }
        }
        throw new RuntimeException("Unknown operator replacement: " + opcodeOrig + " -> " + opcodeNew);
    }

    public static double getInfectionDistance(int intVal, int opcodeOrig, int opcodeNew) {
        long val = intVal;
        switch (opcodeOrig) {
            case 155: {
                switch (opcodeNew) {
                    case 158: {
                        return Math.abs(val);
                    }
                    case 153: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case 157: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 156: {
                        return 0.0;
                    }
                    case 154: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case -1: {
                        return val < 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val < 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 158: {
                switch (opcodeNew) {
                    case 155: {
                        return Math.abs(val);
                    }
                    case 153: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 156: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 157: {
                        return 0.0;
                    }
                    case 154: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case -1: {
                        return val <= 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val <= 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 157: {
                switch (opcodeNew) {
                    case 156: {
                        return Math.abs(val);
                    }
                    case 153: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 155: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 158: {
                        return 0.0;
                    }
                    case 154: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case -1: {
                        return val > 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val > 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 156: {
                switch (opcodeNew) {
                    case 157: {
                        return Math.abs(val);
                    }
                    case 153: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case 158: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case 155: {
                        return 0.0;
                    }
                    case 154: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case -1: {
                        return val >= 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val >= 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 153: {
                switch (opcodeNew) {
                    case 155: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case 157: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 154: {
                        return 0.0;
                    }
                    case 158: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 156: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case -1: {
                        return val == 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val == 0L ? 0.0 : 1.0;
                    }
                }
            }
            case 154: {
                switch (opcodeNew) {
                    case 153: {
                        return 0.0;
                    }
                    case 155: {
                        return val <= 0L ? (double)Math.abs(val) + 1.0 : 0.0;
                    }
                    case 158: {
                        return val < 0L ? (double)Math.abs(val) : 0.0;
                    }
                    case 157: {
                        return val >= 0L ? (double)val + 1.0 : 0.0;
                    }
                    case 156: {
                        return val > 0L ? (double)val : 0.0;
                    }
                    case -1: {
                        return val != 0L ? 1.0 : 0.0;
                    }
                    case -2: {
                        return val != 0L ? 0.0 : 1.0;
                    }
                }
            }
        }
        throw new RuntimeException("Unknown operator replacement: " + opcodeOrig + " -> " + opcodeNew);
    }

    private Set<Integer> getOperators(int opcode, boolean isBoolean) {
        HashSet<Integer> replacement = new HashSet<Integer>();
        if (opcodesReference.contains(opcode)) {
            replacement.addAll(opcodesReference);
        } else if (opcodesNull.contains(opcode)) {
            replacement.addAll(opcodesNull);
        } else if (opcodesInt.contains(opcode)) {
            if (isBoolean) {
                replacement.add(this.getBooleanIntReplacement(opcode));
            } else {
                replacement.addAll(this.getIntReplacement(opcode));
            }
        } else if (opcodesIntInt.contains(opcode)) {
            if (isBoolean) {
                replacement.add(this.getBooleanIntIntReplacement(opcode));
            } else {
                replacement.addAll(this.getIntIntReplacement(opcode));
            }
        }
        replacement.remove(opcode);
        return replacement;
    }

    private int getBooleanIntReplacement(int opcode) {
        logger.debug("Getting Boolean int replacement");
        switch (opcode) {
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 157: {
                return 153;
            }
            case 158: {
                return 157;
            }
            case 156: {
                return 155;
            }
            case 155: {
                return 156;
            }
        }
        throw new RuntimeException("Illegal opcode received: " + opcode);
    }

    private int getBooleanIntIntReplacement(int opcode) {
        logger.debug("Getting Boolean int int replacement");
        switch (opcode) {
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 163: {
                return 159;
            }
            case 164: {
                return 163;
            }
            case 162: {
                return 161;
            }
            case 161: {
                return 162;
            }
        }
        throw new RuntimeException("Illegal opcode received: " + opcode);
    }

    private Set<Integer> getIntReplacement(int opcode) {
        logger.debug("Getting int replacement");
        HashSet<Integer> replacement = new HashSet<Integer>();
        switch (opcode) {
            case 153: {
                replacement.add(156);
                replacement.add(158);
                replacement.add(-2);
                break;
            }
            case 154: {
                replacement.add(155);
                replacement.add(157);
                replacement.add(-1);
                break;
            }
            case 157: {
                replacement.add(156);
                replacement.add(154);
                replacement.add(-2);
                break;
            }
            case 158: {
                replacement.add(155);
                replacement.add(153);
                replacement.add(-1);
                break;
            }
            case 156: {
                replacement.add(157);
                replacement.add(153);
                replacement.add(-1);
                break;
            }
            case 155: {
                replacement.add(158);
                replacement.add(154);
                replacement.add(-2);
            }
        }
        return replacement;
    }

    private Set<Integer> getIntIntReplacement(int opcode) {
        logger.info("Getting int int replacement");
        HashSet<Integer> replacement = new HashSet<Integer>();
        switch (opcode) {
            case 159: {
                replacement.add(162);
                replacement.add(164);
                replacement.add(-2);
                break;
            }
            case 160: {
                replacement.add(161);
                replacement.add(163);
                replacement.add(-1);
                break;
            }
            case 163: {
                replacement.add(162);
                replacement.add(160);
                replacement.add(-2);
                break;
            }
            case 164: {
                replacement.add(161);
                replacement.add(159);
                replacement.add(-1);
                break;
            }
            case 162: {
                replacement.add(163);
                replacement.add(159);
                replacement.add(-1);
                break;
            }
            case 161: {
                replacement.add(164);
                replacement.add(160);
                replacement.add(-2);
            }
        }
        return replacement;
    }

    @Override
    public boolean isApplicable(BytecodeInstruction instruction) {
        return instruction.isBranch();
    }

    static {
        opcodesReference.addAll(Arrays.asList(165, 166));
        opcodesNull.addAll(Arrays.asList(198, 199));
        opcodesInt.addAll(Arrays.asList(153, 154, 156, 157, 158, 155));
        opcodesIntInt.addAll(Arrays.asList(159, 162, 163, 164, 161, 160));
    }
}

