/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.util.Arrays;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeAnalyzer;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.instrumentation.BooleanArrayInterpreter;
import org.evosuite.instrumentation.BooleanValueInterpreter;
import org.evosuite.instrumentation.TransformationStatistics;
import org.evosuite.instrumentation.testability.BooleanHelper;
import org.evosuite.instrumentation.testability.DescriptorMapping;
import org.evosuite.instrumentation.testability.transformer.BitwiseOperatorTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanArrayIndexTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanArrayTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanCallsTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanDefinitionTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanDistanceTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanIfTransformer;
import org.evosuite.instrumentation.testability.transformer.BooleanReturnTransformer;
import org.evosuite.instrumentation.testability.transformer.ImplicitElseTransformer;
import org.evosuite.instrumentation.testability.transformer.InstanceOfTransformer;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanTestabilityTransformation {
    public static final Logger logger = LoggerFactory.getLogger(BooleanTestabilityTransformation.class);
    private final ClassNode cn;
    public final String className;
    public Frame[] currentFrames = null;
    private MethodNode currentMethodNode = null;
    public ClassLoader classLoader;

    public BooleanTestabilityTransformation(ClassNode cn, ClassLoader classLoader) {
        this.cn = cn;
        this.className = cn.name.replace('/', '.');
        this.classLoader = classLoader;
    }

    public ClassNode transform() {
        this.processFields();
        this.processMethods();
        this.clearIntermediateResults();
        if (this.className.equals(Properties.TARGET_CLASS) || this.className.startsWith(Properties.TARGET_CLASS + "$")) {
            TransformationStatistics.writeStatistics(this.className);
        }
        return this.cn;
    }

    private void clearIntermediateResults() {
        List methodNodes = this.cn.methods;
        for (MethodNode mn : methodNodes) {
            if ((mn.access & 0x100) == 256) continue;
            GraphPool.clearAll(this.className, mn.name + mn.desc);
            BytecodeInstructionPool.clearAll(this.className, mn.name + mn.desc);
            BranchPool.getInstance(this.classLoader).clear(this.className, mn.name + mn.desc);
        }
    }

    private void processFields() {
        List fields = this.cn.fields;
        for (FieldNode field : fields) {
            if (!DescriptorMapping.getInstance().isTransformedField(this.className, field.name, field.desc)) continue;
            String newDesc = this.transformFieldDescriptor(this.className, field.name, field.desc);
            logger.info("Transforming field " + field.name + " from " + field.desc + " to " + newDesc);
            if (!newDesc.equals(field.desc)) {
                TransformationStatistics.transformBooleanField();
            }
            field.desc = newDesc;
        }
    }

    private void processMethods() {
        List methodNodes = this.cn.methods;
        for (MethodNode mn : methodNodes) {
            if ((mn.access & 0x100) == 256) continue;
            if (DescriptorMapping.getInstance().isTransformedMethod(this.className, mn.name, mn.desc)) {
                logger.info("Transforming signature of method " + mn.name + mn.desc);
                this.transformMethodSignature(mn);
                logger.info("Transformed signature to " + mn.name + mn.desc);
            }
            this.transformMethod(mn);
        }
    }

    public static String getOriginalNameDesc(String className, String methodName, String desc) {
        String key = className.replace('.', '/') + "/" + methodName + desc;
        if (DescriptorMapping.getInstance().originalDesc.containsKey(key)) {
            logger.debug("Descriptor mapping contains original for " + key);
            return DescriptorMapping.getInstance().getOriginalName(className, methodName, desc) + DescriptorMapping.getInstance().originalDesc.get(key);
        }
        logger.debug("Descriptor mapping does not contain original for " + key);
        return methodName + desc;
    }

    public static String getOriginalDesc(String className, String methodName, String desc) {
        String key = className.replace('.', '/') + "/" + methodName + desc;
        if (DescriptorMapping.getInstance().originalDesc.containsKey(key)) {
            logger.debug("Descriptor mapping contains original for " + key);
            return DescriptorMapping.getInstance().originalDesc.get(key);
        }
        logger.debug("Descriptor mapping does not contain original for " + key);
        return desc;
    }

    public static boolean hasTransformedParameters(String className, String methodName, String desc) {
        String key = className.replace('.', '/') + "/" + methodName + desc;
        if (DescriptorMapping.getInstance().originalDesc.containsKey(key)) {
            for (Type type : Type.getArgumentTypes((String)DescriptorMapping.getInstance().originalDesc.get(key))) {
                if (!type.equals((Object)Type.BOOLEAN_TYPE)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTransformedField(String className, String fieldName, String desc) {
        return DescriptorMapping.getInstance().isTransformedField(className, fieldName, desc);
    }

    public void insertPushNull(int opcode, JumpInsnNode position, InsnList list) {
        int branchId = this.getBranchID(this.currentMethodNode, position);
        logger.info("Inserting instrumentation for NULL check at branch " + branchId + " in method " + this.currentMethodNode.name);
        MethodInsnNode nullCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "isNull", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new InsnNode(89));
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new LdcInsnNode((Object)opcode));
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)nullCheck);
        this.insertBranchIdPlaceholder(this.currentMethodNode, position, branchId);
        MethodInsnNode push = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushPredicate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)push);
    }

    public void insertPushEquals(int opcode, JumpInsnNode position, InsnList list) {
        MethodInsnNode equalCheck = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "isEqual", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class), Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new InsnNode(92));
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new LdcInsnNode((Object)opcode));
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)equalCheck);
        this.insertBranchIdPlaceholder(this.currentMethodNode, position);
        MethodInsnNode push = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushPredicate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)push);
    }

    private BytecodeInstruction getBytecodeInstruction(MethodNode mn, AbstractInsnNode node) {
        return BytecodeInstructionPool.getInstance(this.classLoader).getInstruction(this.className, mn.name + mn.desc, node);
    }

    private int getBranchID(MethodNode mn, JumpInsnNode jumpNode) {
        assert (mn.instructions.contains((AbstractInsnNode)jumpNode));
        BytecodeInstruction insn = this.getBytecodeInstruction(mn, (AbstractInsnNode)jumpNode);
        logger.info("Found instruction: " + insn);
        Branch branch = BranchPool.getInstance(this.classLoader).getBranchForInstruction(insn);
        return branch.getActualBranchId();
    }

    private int getControlDependentBranchID(MethodNode mn, AbstractInsnNode insnNode) {
        BytecodeInstruction insn = this.getBytecodeInstruction(mn, insnNode);
        return insn.getControlDependentBranchId();
    }

    private int getApproximationLevel(MethodNode mn, AbstractInsnNode insnNode) {
        BytecodeInstruction insn = this.getBytecodeInstruction(mn, insnNode);
        return insn.getCDGDepth();
    }

    private void insertBranchIdPlaceholder(MethodNode mn, JumpInsnNode jumpNode) {
        Label label = new Label();
        LabelNode labelNode = new LabelNode(label);
        mn.instructions.insertBefore((AbstractInsnNode)jumpNode, (AbstractInsnNode)labelNode);
        mn.instructions.insertBefore((AbstractInsnNode)jumpNode, (AbstractInsnNode)new LdcInsnNode((Object)this.getBranchID(mn, jumpNode)));
    }

    private void insertBranchIdPlaceholder(MethodNode mn, JumpInsnNode jumpNode, int branchId) {
        Label label = new Label();
        LabelNode labelNode = new LabelNode(label);
        mn.instructions.insertBefore((AbstractInsnNode)jumpNode, (AbstractInsnNode)labelNode);
        mn.instructions.insertBefore((AbstractInsnNode)jumpNode, (AbstractInsnNode)new LdcInsnNode((Object)branchId));
    }

    private void insertControlDependencyPlaceholder(MethodNode mn, AbstractInsnNode insnNode) {
        Label label = new Label();
        LabelNode labelNode = new LabelNode(label);
        mn.instructions.insertBefore(insnNode, (AbstractInsnNode)labelNode);
        mn.instructions.insertBefore(insnNode, (AbstractInsnNode)new LdcInsnNode((Object)this.getControlDependentBranchID(mn, insnNode)));
        mn.instructions.insertBefore(insnNode, (AbstractInsnNode)new LdcInsnNode((Object)this.getApproximationLevel(mn, insnNode)));
        logger.info("Control dependent branch id: " + this.getControlDependentBranchID(mn, insnNode));
        logger.info("Approximation level: " + this.getApproximationLevel(mn, insnNode));
    }

    public void insertPush(int opcode, JumpInsnNode position, InsnList list) {
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new InsnNode(89));
        this.insertBranchIdPlaceholder(this.currentMethodNode, position);
        MethodInsnNode push = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushPredicate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)push);
    }

    public void insertPush2(int opcode, JumpInsnNode position, InsnList list) {
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)new InsnNode(92));
        MethodInsnNode sub = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "intSub", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)sub);
        this.insertBranchIdPlaceholder(this.currentMethodNode, position);
        MethodInsnNode push = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "pushPredicate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore((AbstractInsnNode)position, (AbstractInsnNode)push);
    }

    public void insertGet(AbstractInsnNode position, InsnList list) {
        logger.info("Inserting get call");
        this.insertControlDependencyPlaceholder(this.currentMethodNode, position);
        MethodInsnNode get = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "getDistance", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insert(position, (AbstractInsnNode)get);
    }

    public void insertGetBefore(AbstractInsnNode position, InsnList list) {
        logger.info("Inserting get call before");
        Label label = new Label();
        LabelNode labelNode = new LabelNode(label);
        this.currentMethodNode.instructions.insertBefore(position, (AbstractInsnNode)labelNode);
        this.currentMethodNode.instructions.insertBefore(position, (AbstractInsnNode)new LdcInsnNode((Object)this.getControlDependentBranchID(this.currentMethodNode, position)));
        this.currentMethodNode.instructions.insertBefore(position, (AbstractInsnNode)new InsnNode(95));
        this.currentMethodNode.instructions.insertBefore(position, (AbstractInsnNode)new LdcInsnNode((Object)this.getApproximationLevel(this.currentMethodNode, position)));
        this.currentMethodNode.instructions.insertBefore(position, (AbstractInsnNode)new InsnNode(95));
        MethodInsnNode get = new MethodInsnNode(184, Type.getInternalName(BooleanHelper.class), "getDistance", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE}), false);
        list.insertBefore(position, (AbstractInsnNode)get);
    }

    public boolean isBooleanOnStack(MethodNode mn, AbstractInsnNode node, int position) {
        int insnPosition = mn.instructions.indexOf(node);
        if (insnPosition >= this.currentFrames.length) {
            logger.info("Trying to access frame out of scope: " + insnPosition + "/" + this.currentFrames.length);
            return false;
        }
        Frame frame = this.currentFrames[insnPosition];
        return frame.getStack(frame.getStackSize() - 1 - position) == BooleanValueInterpreter.BOOLEAN_VALUE;
    }

    public boolean isBooleanVariable(int var, MethodNode mn) {
        for (Object o : mn.localVariables) {
            LocalVariableNode vn = (LocalVariableNode)o;
            if (vn.index != var) continue;
            return Type.getType((String)vn.desc).equals((Object)Type.BOOLEAN_TYPE);
        }
        return false;
    }

    public boolean isBooleanAssignment(AbstractInsnNode position, MethodNode mn) {
        AbstractInsnNode node = position.getNext();
        logger.info("Checking for ISTORE after boolean");
        boolean done = false;
        while (!done) {
            if (node.getOpcode() == 181 || node.getOpcode() == 179) {
                logger.info("Checking field assignment");
                FieldInsnNode fn = (FieldInsnNode)node;
                return Type.getType((String)DescriptorMapping.getInstance().getFieldDesc(fn.owner, fn.name, fn.desc)) == Type.BOOLEAN_TYPE;
            }
            if (node.getOpcode() == 54) {
                logger.info("Found ISTORE after boolean");
                VarInsnNode vn = (VarInsnNode)node;
                if (this.isBooleanVariable(vn.var, mn)) {
                    logger.info("Assigning boolean to variable ");
                    return true;
                }
                logger.info("Variable is not a bool");
                return false;
            }
            if (node.getOpcode() == 172) {
                logger.info("Checking return value of method " + this.cn.name + "." + mn.name);
                if (DescriptorMapping.getInstance().isTransformedOrBooleanMethod(this.cn.name, mn.name, mn.desc)) {
                    logger.info("Method returns a bool");
                    return true;
                }
                logger.info("Method does not return a bool");
                return false;
            }
            if (node.getOpcode() == 84) {
                boolean reassignment = false;
                for (AbstractInsnNode start = position.getNext(); start != node; start = start.getNext()) {
                    if (!(node instanceof InsnNode)) continue;
                    reassignment = true;
                }
                logger.info("Possible assignment to array?");
                return !reassignment;
            }
            if (node instanceof MethodInsnNode) {
                MethodInsnNode methodNode = (MethodInsnNode)node;
                String desc = DescriptorMapping.getInstance().getMethodDesc(methodNode.owner, methodNode.name, methodNode.desc);
                Type[] types = Type.getArgumentTypes((String)desc);
                return types.length > 0 && types[types.length - 1] == Type.BOOLEAN_TYPE;
            }
            if (node.getOpcode() == 167 || node.getOpcode() == 3 || node.getOpcode() == 4 || node.getOpcode() == -1) {
                logger.info("Continuing search");
            } else if (!(node instanceof LineNumberNode) && !(node instanceof FrameNode)) {
                logger.info("Search ended with opcode " + node.getOpcode());
                return false;
            }
            if (node != mn.instructions.getLast()) {
                node = node.getNext();
                continue;
            }
            done = true;
        }
        return false;
    }

    private void generateCDG(MethodNode mn) {
        if (BytecodeInstructionPool.getInstance(this.classLoader).hasMethod(this.className, mn.name + mn.desc)) {
            return;
        }
        BytecodeInstructionPool.getInstance(this.classLoader).registerMethodNode(mn, this.className, mn.name + mn.desc);
        BytecodeAnalyzer bytecodeAnalyzer = new BytecodeAnalyzer();
        logger.info("Generating initial CFG for method " + mn.name);
        try {
            bytecodeAnalyzer.analyze(this.classLoader, this.className, mn.name + mn.desc, mn);
        }
        catch (AnalyzerException e) {
            logger.error("Analyzer exception while analyzing " + this.className + "." + mn.name + ": " + (Object)((Object)e));
            e.printStackTrace();
        }
        bytecodeAnalyzer.retrieveCFGGenerator().registerCFGs();
    }

    public String transformMethodDescriptor(String owner, String name, String desc) {
        return DescriptorMapping.getInstance().getMethodDesc(owner, name, desc);
    }

    public String transformFieldDescriptor(String owner, String name, String desc) {
        return DescriptorMapping.getInstance().getFieldDesc(owner, name, desc);
    }

    private void transformMethodSignature(MethodNode mn) {
        String newDesc = DescriptorMapping.getInstance().getMethodDesc(this.className, mn.name, mn.desc);
        if (Type.getReturnType((String)mn.desc) == Type.BOOLEAN_TYPE && Type.getReturnType((String)newDesc) == Type.INT_TYPE) {
            TransformationStatistics.transformBooleanReturnValue();
        }
        if (Arrays.asList(Type.getArgumentTypes((String)mn.desc)).contains(Type.BOOLEAN_TYPE) && !Arrays.asList(Type.getArgumentTypes((String)newDesc)).contains(Type.BOOLEAN_TYPE)) {
            TransformationStatistics.transformBooleanParameter();
        }
        String newName = DescriptorMapping.getInstance().getMethodName(this.className, mn.name, mn.desc);
        logger.info("Changing method descriptor from " + mn.name + mn.desc + " to " + DescriptorMapping.getInstance().getMethodName(this.className, mn.name, mn.desc) + newDesc);
        mn.desc = DescriptorMapping.getInstance().getMethodDesc(this.className, mn.name, mn.desc);
        mn.name = newName;
    }

    private Frame[] getArrayFrames(MethodNode mn) {
        try {
            Analyzer a = new Analyzer((Interpreter)new BooleanArrayInterpreter());
            a.analyze(this.cn.name, mn);
            return a.getFrames();
        }
        catch (Exception e) {
            logger.info("[Array] Error during analysis: " + e);
            return null;
        }
    }

    private void transformMethod(MethodNode mn) {
        Analyzer a;
        logger.info("Transforming method " + mn.name + mn.desc);
        if ((mn.access & 0x400) == 1024) {
            return;
        }
        String origDesc = BooleanTestabilityTransformation.getOriginalDesc(this.className, mn.name, mn.desc);
        logger.info("Analyzing " + mn.name + " for TT, signature " + origDesc + "/" + mn.desc);
        try {
            a = new Analyzer((Interpreter)new BooleanValueInterpreter(origDesc, (mn.access & 8) == 8));
            a.analyze(this.className, mn);
            this.currentFrames = a.getFrames();
        }
        catch (Exception e) {
            logger.info("1. Error during analysis: " + e);
        }
        this.generateCDG(mn);
        this.currentMethodNode = mn;
        new ImplicitElseTransformer(this).transform(mn);
        try {
            a = new Analyzer((Interpreter)new BooleanValueInterpreter(origDesc, (mn.access & 8) == 8));
            a.analyze(this.className, mn);
            this.currentFrames = a.getFrames();
        }
        catch (Exception e) {
            logger.info("2. Error during analysis: " + e);
        }
        logger.info("Transforming Boolean bitwise operators");
        new BitwiseOperatorTransformer(this).transform(mn);
        logger.info("Transforming Boolean IFs");
        new BooleanIfTransformer(this).transform(mn);
        logger.info("Transforming Boolean definitions");
        new BooleanDefinitionTransformer(this).transform(mn);
        logger.info("Transforming instanceof");
        new InstanceOfTransformer().transform(mn);
        new BooleanCallsTransformer(this).transform(mn);
        logger.info("Transforming Boolean distances");
        new BooleanDistanceTransformer(this).transform(mn);
        mn.maxStack += 3;
        new BooleanArrayTransformer().transform(mn);
        new BooleanArrayIndexTransformer(this.getArrayFrames(mn)).transform(mn);
        logger.info("Transforming Boolean return values");
        new BooleanReturnTransformer(this).transform(mn);
        ++mn.maxStack;
    }
}

