/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability;

import java.util.Collection;
import java.util.Map;
import org.evosuite.instrumentation.testability.StringHelper;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.setup.TestCluster;

public class ContainerHelper {
    public static int mapIsEmpty(Map<?, ?> m) {
        return m.isEmpty() ? 0x7FFFFFFD : -m.size();
    }

    public static int collectionIsEmpty(Collection<?> c) {
        return c.isEmpty() ? 0x7FFFFFFD : -c.size();
    }

    public static int collectionContains(Collection<?> c, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        int matching = 0;
        double min_distance = Double.MAX_VALUE;
        for (Object o2 : c) {
            if (o2 == o1 || o2 != null && o2.equals(o1)) {
                ++matching;
                continue;
            }
            if (o2 == null || o1 == null || !o2.getClass().equals(o1.getClass())) continue;
            if (o1 instanceof Number) {
                Number n1 = (Number)o1;
                Number n2 = (Number)o2;
                min_distance = Math.min(min_distance, Math.abs(n1.doubleValue() - n2.doubleValue()));
                continue;
            }
            if (!(o2 instanceof String)) continue;
            ConstantPoolManager.getInstance().addDynamicConstant(o1);
            min_distance = Math.min(min_distance, (double)StringHelper.editDistance((String)o1, (String)o2));
        }
        if (matching > 0) {
            return matching;
        }
        if (min_distance == Double.MAX_VALUE) {
            return -c.size() - 1;
        }
        return -1 * (int)Math.ceil(2.147483645E9 * min_distance / (min_distance + 1.0));
    }

    public static int collectionContainsAll(Collection<?> c, Collection<?> c2) {
        int mismatch = 0;
        for (Object o : c2) {
            if (c.contains(o)) continue;
            ++mismatch;
        }
        return mismatch > 0 ? -mismatch : c2.size() + 1;
    }

    public static int mapContainsKey(Map<?, ?> m, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        return ContainerHelper.collectionContains(m.keySet(), o1);
    }

    public static int mapContainsValue(Map<?, ?> m, Object o1) {
        if (o1 != null) {
            TestCluster.getInstance().addCastClassForContainer(o1.getClass());
        }
        return ContainerHelper.collectionContains(m.values(), o1);
    }
}

