/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.instrumentation.testability.transformer;

import org.evosuite.instrumentation.BooleanArrayInterpreter;
import org.evosuite.instrumentation.testability.BooleanTestabilityTransformation;
import org.evosuite.instrumentation.testability.transformer.MethodNodeTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Frame;

public class BooleanArrayIndexTransformer
extends MethodNodeTransformer {
    private final Frame[] frames;

    public BooleanArrayIndexTransformer(Frame[] frames) {
        this.frames = frames;
    }

    @Override
    protected AbstractInsnNode transformInsnNode(MethodNode mn, InsnNode insnNode) {
        int size;
        Frame current;
        if (this.frames == null) {
            return insnNode;
        }
        if (insnNode.getOpcode() == 51) {
            int size2;
            Frame current2 = this.frames[mn.instructions.indexOf((AbstractInsnNode)insnNode)];
            if (current2.getStack((size2 = current2.getStackSize()) - 2) == BooleanArrayInterpreter.INT_ARRAY) {
                BooleanTestabilityTransformation.logger.info("Array is of boolean type, changing BALOAD to IALOAD");
                InsnNode replacement = new InsnNode(46);
                mn.instructions.insertBefore((AbstractInsnNode)insnNode, (AbstractInsnNode)replacement);
                mn.instructions.remove((AbstractInsnNode)insnNode);
                return replacement;
            }
        } else if (insnNode.getOpcode() == 84 && (current = this.frames[mn.instructions.indexOf((AbstractInsnNode)insnNode)]).getStack((size = current.getStackSize()) - 3) == BooleanArrayInterpreter.INT_ARRAY) {
            BooleanTestabilityTransformation.logger.info("Array is of boolean type, changing BASTORE to IASTORE");
            InsnNode replacement = new InsnNode(79);
            mn.instructions.insertBefore((AbstractInsnNode)insnNode, (AbstractInsnNode)replacement);
            mn.instructions.remove((AbstractInsnNode)insnNode);
            return replacement;
        }
        return insnNode;
    }

    @Override
    protected AbstractInsnNode transformTypeInsnNode(MethodNode mn, TypeInsnNode typeNode) {
        int size;
        Frame current;
        if (this.frames == null) {
            return typeNode;
        }
        if (typeNode.getOpcode() == 192 && (current = this.frames[mn.instructions.indexOf((AbstractInsnNode)typeNode)]).getStack((size = current.getStackSize()) - 1) == BooleanArrayInterpreter.INT_ARRAY) {
            BooleanTestabilityTransformation.logger.info("Array is of boolean type, changing CHECKCAST to [I");
            TypeInsnNode replacement = new TypeInsnNode(192, "[I");
            mn.instructions.insertBefore((AbstractInsnNode)typeNode, (AbstractInsnNode)replacement);
            mn.instructions.remove((AbstractInsnNode)typeNode);
            return replacement;
        }
        return typeNode;
    }
}

