/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.junit.naming.methods;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.coverage.io.input.InputObserver;
import org.evosuite.coverage.io.output.OutputCoverageTestFitness;
import org.evosuite.coverage.io.output.OutputObserver;
import org.evosuite.coverage.method.MethodCoverageTestFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageTestFitness;
import org.evosuite.junit.naming.methods.GoalComparator;
import org.evosuite.junit.naming.methods.TestNameGenerationStrategy;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.objectweb.asm.Type;

public class CoverageGoalTestNameGenerationStrategy
implements TestNameGenerationStrategy {
    private Map<TestCase, String> testToName = new LinkedHashMap<TestCase, String>();
    private Map<String, Set<String>> methodCount = new LinkedHashMap<String, Set<String>>();
    public static final String PREFIX = "test";
    public static final String STR_CREATE = "Creates";
    public static final String STR_CREATE_EXCEPTION = "FailsToCreate";
    public static final String STR_THROWS = "Throws";
    public static final String STR_WITH = "With";
    public static final String STR_WHERE = "Where";
    public static final String STR_IS = "Is";
    public static final String STR_AND = "And";
    public static final String STR_TAKING = "Taking";
    public static final String STR_WITHOUT = "TakingNo";
    public static final String STR_RETURNS = "Returning";
    public static final String STR_ARGUMENTS = "Arguments";
    public static final int MAX_SIMILAR_GOALS = 2;
    public static final int MAX_CHARS = 70;
    private List<Class<?>> supportedClasses = Arrays.asList(MethodCoverageTestFitness.class, MethodNoExceptionCoverageTestFitness.class, ExceptionCoverageTestFitness.class, OutputCoverageTestFitness.class, InputCoverageTestFitness.class);

    public CoverageGoalTestNameGenerationStrategy(List<TestCase> testCases, List<ExecutionResult> results) {
        this.addGoalsNotIncludedInTargetCriteria(results);
        Map<TestCase, Set<TestFitnessFunction>> testToGoals = this.initializeCoverageMapFromResults(results);
        this.generateNames(testToGoals);
    }

    public CoverageGoalTestNameGenerationStrategy(List<TestCase> testCases) {
        Map<TestCase, Set<TestFitnessFunction>> testToGoals = this.initializeCoverageMapFromTests(testCases);
        this.generateNames(testToGoals);
    }

    private void initializeNameGoals(Map<TestCase, Set<TestFitnessFunction>> testToGoals) {
        for (Map.Entry<TestCase, Set<TestFitnessFunction>> entry : testToGoals.entrySet()) {
            LinkedHashSet<TestFitnessFunction> goals = new LinkedHashSet<TestFitnessFunction>();
            List<TestFitnessFunction> topGoals = this.getTopGoals(entry.getValue());
            if (!topGoals.isEmpty()) {
                if (topGoals.size() <= 2) {
                    for (TestFitnessFunction goal : topGoals) {
                        goals.add(goal);
                        String goalName = this.getTestName(entry.getKey(), goals);
                        if (goalName.length() <= 70) continue;
                        goals.remove(goal);
                        break;
                    }
                } else {
                    goals.add(this.chooseRepresentativeGoal(entry.getKey(), topGoals));
                }
            }
            testToGoals.put(entry.getKey(), goals);
        }
    }

    private void setTestNames(Map<TestCase, Set<TestFitnessFunction>> testToGoals) {
        for (Map.Entry<TestCase, Set<TestFitnessFunction>> entry : testToGoals.entrySet()) {
            this.testToName.put(entry.getKey(), this.getTestName(entry.getKey(), entry.getValue()));
        }
    }

    private void generateNames(Map<TestCase, Set<TestFitnessFunction>> testToGoals) {
        this.initializeMethodCoverageCount(testToGoals);
        CoverageGoalTestNameGenerationStrategy.findUniqueGoals(testToGoals);
        this.initializeNameGoals(testToGoals);
        boolean changed = true;
        while (changed) {
            this.setTestNames(testToGoals);
            Map<String, Set<TestCase>> dupTestNameMap = this.determineDuplicateNames();
            changed = false;
            for (Map.Entry<String, Set<TestCase>> entry : dupTestNameMap.entrySet()) {
                if (entry.getKey().length() >= 70) continue;
                if (this.resolveAmbiguity(testToGoals, entry.getValue(), true)) {
                    changed = true;
                    continue;
                }
                if (!this.resolveAmbiguity(testToGoals, entry.getValue(), false)) continue;
                changed = true;
            }
        }
        for (Map.Entry<TestCase, Set<TestFitnessFunction>> entry : testToGoals.entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            ArrayList<TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>(this.getUniqueNonMethodGoals(entry.getKey(), testToGoals));
            if (goals.isEmpty()) {
                goals.addAll(this.filterSupportedGoals(entry.getKey().getCoveredGoals()));
            }
            Collections.sort(goals, new GoalComparator());
            if (goals.isEmpty()) continue;
            TestFitnessFunction goal = (TestFitnessFunction)goals.iterator().next();
            entry.getValue().add(goal);
            String name = this.getTestName(entry.getKey(), entry.getValue());
            this.testToName.put(entry.getKey(), name);
        }
        this.fixAmbiguousTestNames();
    }

    private Set<TestFitnessFunction> getUniqueNonMethodGoals(TestCase test, Map<TestCase, Set<TestFitnessFunction>> testToGoals) {
        LinkedHashSet<TestFitnessFunction> allGoals = new LinkedHashSet<TestFitnessFunction>();
        for (Set<TestFitnessFunction> goals : testToGoals.values()) {
            allGoals.addAll(goals);
        }
        LinkedHashSet<TestFitnessFunction> goals = new LinkedHashSet<TestFitnessFunction>();
        for (TestFitnessFunction goal : this.filterSupportedGoals(test.getCoveredGoals())) {
            if (goal instanceof MethodCoverageTestFitness || goal instanceof MethodNoExceptionCoverageTestFitness || allGoals.contains(goal)) continue;
            goals.add(goal);
        }
        return goals;
    }

    private boolean resolveAmbiguity(Map<TestCase, Set<TestFitnessFunction>> testToGoals, Set<TestCase> tests, boolean unique) {
        LinkedHashMap fullTestToGoals = new LinkedHashMap();
        for (TestCase test : tests) {
            Set<TestFitnessFunction> goals = this.filterSupportedGoals(new LinkedHashSet<TestFitnessFunction>(test.getCoveredGoals()));
            goals.removeAll((Collection)testToGoals.get(test));
            fullTestToGoals.put(test, goals);
        }
        if (unique) {
            CoverageGoalTestNameGenerationStrategy.findUniqueGoals(fullTestToGoals);
        } else {
            CoverageGoalTestNameGenerationStrategy.findNonUbiquitousGoals(fullTestToGoals);
        }
        boolean added = false;
        for (TestCase test : tests) {
            String newName;
            List<TestFitnessFunction> topGoals = this.getTopGoals((Set)fullTestToGoals.get(test));
            if (topGoals.isEmpty()) continue;
            if (topGoals.size() > 2) {
                TestFitnessFunction newGoal = this.chooseRepresentativeGoal(test, topGoals);
                LinkedHashSet<TestFitnessFunction> newGoals = new LinkedHashSet<TestFitnessFunction>((Collection)testToGoals.get(test));
                newGoals.add(newGoal);
                newName = this.getTestName(test, newGoals);
                if (newName.length() >= 70 || !testToGoals.get(test).add(newGoal)) continue;
                added = true;
                continue;
            }
            LinkedHashSet<TestFitnessFunction> newGoals = new LinkedHashSet<TestFitnessFunction>((Collection)testToGoals.get(test));
            Iterator<TestFitnessFunction> iterator = topGoals.iterator();
            newName = this.testToName.get(test);
            while (newName.length() < 70 && iterator.hasNext()) {
                TestFitnessFunction newGoal = iterator.next();
                newGoals.add(newGoal);
                newName = this.getTestName(test, newGoals);
                if (!testToGoals.get(test).add(newGoal)) continue;
                added = true;
            }
        }
        return added;
    }

    private Map<TestCase, Set<TestFitnessFunction>> initializeCoverageMapFromTests(List<TestCase> tests) {
        LinkedHashMap<TestCase, Set<TestFitnessFunction>> testToGoals = new LinkedHashMap<TestCase, Set<TestFitnessFunction>>();
        for (TestCase test : tests) {
            testToGoals.put(test, this.filterSupportedGoals(new LinkedHashSet<TestFitnessFunction>(test.getCoveredGoals())));
        }
        return testToGoals;
    }

    private Map<TestCase, Set<TestFitnessFunction>> initializeCoverageMapFromResults(List<ExecutionResult> results) {
        LinkedHashMap<TestCase, Set<TestFitnessFunction>> testToGoals = new LinkedHashMap<TestCase, Set<TestFitnessFunction>>();
        for (ExecutionResult result : results) {
            testToGoals.put(result.test, this.filterSupportedGoals(new LinkedHashSet<TestFitnessFunction>(result.test.getCoveredGoals())));
        }
        return testToGoals;
    }

    private void addGoalsNotIncludedInTargetCriteria(List<ExecutionResult> results) {
        ArrayList<Properties.Criterion> requiredCriteria = new ArrayList<Properties.Criterion>(Arrays.asList(Properties.Criterion.OUTPUT, Properties.Criterion.INPUT, Properties.Criterion.METHOD, Properties.Criterion.METHODNOEXCEPTION, Properties.Criterion.EXCEPTION));
        requiredCriteria.removeAll(Arrays.asList(Properties.CRITERION));
        results = this.getUpdatedResults(requiredCriteria, results);
        for (Properties.Criterion c : requiredCriteria) {
            TestFitnessFactory<? extends TestFitnessFunction> goalFactory = FitnessFunctions.getFitnessFactory(c);
            List<? extends TestFitnessFunction> goals = goalFactory.getCoverageGoals();
            for (ExecutionResult result : results) {
                for (TestFitnessFunction testFitnessFunction : goals) {
                    if (!testFitnessFunction.isCovered(result)) continue;
                    result.test.addCoveredGoal(testFitnessFunction);
                }
            }
        }
    }

    private List<ExecutionResult> getUpdatedResults(List<Properties.Criterion> requiredCriteria, List<ExecutionResult> origResults) {
        ArrayList<ExecutionObserver> newObservers = new ArrayList<ExecutionObserver>();
        if (requiredCriteria.contains((Object)Properties.Criterion.INPUT)) {
            newObservers.add(new InputObserver());
        }
        if (requiredCriteria.contains((Object)Properties.Criterion.OUTPUT)) {
            newObservers.add(new OutputObserver());
        }
        if (newObservers.isEmpty()) {
            return origResults;
        }
        for (ExecutionObserver observer : newObservers) {
            TestCaseExecutor.getInstance().addObserver(observer);
        }
        ArrayList<ExecutionResult> newResults = new ArrayList<ExecutionResult>();
        for (ExecutionResult result : origResults) {
            TestCaseExecutor.getInstance();
            ExecutionResult newResult = TestCaseExecutor.runTest(result.test);
            newResults.add(newResult);
        }
        for (ExecutionObserver observer : newObservers) {
            TestCaseExecutor.getInstance().removeObserver(observer);
        }
        return newResults;
    }

    private Set<TestFitnessFunction> filterSupportedGoals(Set<TestFitnessFunction> goals) {
        return goals.stream().filter(c -> this.supportedClasses.contains(c.getClass())).collect(Collectors.toSet());
    }

    private void initializeMethodCoverageCount(Map<TestCase, Set<TestFitnessFunction>> testToGoals) {
        for (Set<TestFitnessFunction> goals : testToGoals.values()) {
            for (TestFitnessFunction goal : goals) {
                String methodName = this.getMethodNameWithoutDescriptor(goal.getTargetMethod());
                if (!this.methodCount.containsKey(methodName)) {
                    this.methodCount.put(methodName, new LinkedHashSet());
                }
                this.methodCount.get(methodName).add(goal.getTargetMethod());
            }
        }
    }

    private static <T> void findUniqueGoals(Map<TestCase, Set<T>> testToGoals) {
        LinkedHashMap goalMapCopy = new LinkedHashMap();
        for (Map.Entry<TestCase, Set<T>> entry : testToGoals.entrySet()) {
            LinkedHashSet goalSet = new LinkedHashSet(entry.getValue());
            for (Map.Entry<TestCase, Set<T>> otherEntry : testToGoals.entrySet()) {
                if (entry == otherEntry) continue;
                goalSet.removeAll((Collection)otherEntry.getValue());
            }
            goalMapCopy.put(entry.getKey(), goalSet);
        }
        testToGoals.clear();
        testToGoals.putAll(goalMapCopy);
    }

    private static <T> void findNonUbiquitousGoals(Map<TestCase, Set<T>> testToGoals) {
        LinkedHashMap goalMapCopy = new LinkedHashMap();
        LinkedHashSet commonGoals = new LinkedHashSet();
        for (Map.Entry<TestCase, Set<T>> entry : testToGoals.entrySet()) {
            commonGoals.addAll(entry.getValue());
        }
        for (Map.Entry<TestCase, Set<T>> entry : testToGoals.entrySet()) {
            commonGoals.retainAll((Collection)entry.getValue());
        }
        for (Map.Entry<TestCase, Set<T>> entry : testToGoals.entrySet()) {
            LinkedHashSet goalSet = new LinkedHashSet(entry.getValue());
            goalSet.removeAll(commonGoals);
            goalMapCopy.put(entry.getKey(), goalSet);
        }
        testToGoals.putAll(goalMapCopy);
    }

    private Map<String, Set<TestCase>> determineDuplicateNames() {
        LinkedHashMap<String, Set<TestCase>> testMap = new LinkedHashMap<String, Set<TestCase>>();
        for (Map.Entry<TestCase, String> entry : this.testToName.entrySet()) {
            String methodName = entry.getValue();
            if (!testMap.containsKey(methodName)) {
                LinkedHashSet<TestCase> tests = new LinkedHashSet<TestCase>();
                tests.add(entry.getKey());
                testMap.put(methodName, tests);
                continue;
            }
            ((Set)testMap.get(methodName)).add(entry.getKey());
        }
        testMap.entrySet().removeIf(p -> ((Set)p.getValue()).size() <= 1);
        return testMap;
    }

    private void resolveAmbiguity(Set<TestCase> tests) {
        LinkedHashMap testToGoals = new LinkedHashMap();
        for (TestCase test : tests) {
            testToGoals.put(test, this.filterSupportedGoals(new LinkedHashSet<TestFitnessFunction>(test.getCoveredGoals())));
        }
        CoverageGoalTestNameGenerationStrategy.findUniqueGoals(testToGoals);
    }

    private void fixAmbiguousTestNames() {
        LinkedHashMap<String, Integer> nameCount = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> testCount = new LinkedHashMap<String, Integer>();
        for (String string : this.testToName.values()) {
            if (nameCount.containsKey(string)) {
                nameCount.put(string, (Integer)nameCount.get(string) + 1);
                continue;
            }
            nameCount.put(string, 1);
            testCount.put(string, 0);
        }
        for (Map.Entry entry : this.testToName.entrySet()) {
            if ((Integer)nameCount.get(entry.getValue()) <= 1) continue;
            int num = (Integer)testCount.get(entry.getValue());
            testCount.put((String)entry.getValue(), num + 1);
            this.testToName.put((TestCase)entry.getKey(), (String)entry.getValue() + num);
        }
    }

    private static String capitalize(String input) {
        char[] buffer = input.toCharArray();
        buffer[0] = Character.toTitleCase(buffer[0]);
        return new String(buffer);
    }

    private String getTestName(TestCase test, Set<TestFitnessFunction> uniqueGoals) {
        ArrayList<TestFitnessFunction> goalList = new ArrayList<TestFitnessFunction>(uniqueGoals);
        String name = PREFIX;
        if (goalList.isEmpty()) {
            return name;
        }
        if (goalList.size() == 1) {
            name = name + CoverageGoalTestNameGenerationStrategy.capitalize(this.getGoalName((TestFitnessFunction)goalList.get(0)));
        } else if (goalList.size() == 2) {
            name = name + this.getGoalPairName((TestFitnessFunction)goalList.get(0), (TestFitnessFunction)goalList.get(1));
        } else {
            name = name + this.getGoalName((TestFitnessFunction)goalList.get(0));
            for (int i = 1; i < goalList.size(); ++i) {
                name = name + STR_AND + this.getGoalName((TestFitnessFunction)goalList.get(i));
            }
        }
        return name;
    }

    private List<TestFitnessFunction> getTopGoals(Set<TestFitnessFunction> coveredGoals) {
        TestFitnessFunction nextGoal;
        ArrayList<TestFitnessFunction> goalList = new ArrayList<TestFitnessFunction>(coveredGoals);
        Collections.sort(goalList, new GoalComparator());
        ArrayList<TestFitnessFunction> topGoals = new ArrayList<TestFitnessFunction>();
        if (coveredGoals.isEmpty()) {
            return topGoals;
        }
        Iterator iterator = goalList.iterator();
        TestFitnessFunction lastGoal = (TestFitnessFunction)iterator.next();
        topGoals.add(lastGoal);
        while (iterator.hasNext() && (nextGoal = (TestFitnessFunction)iterator.next()).getClass().equals(lastGoal.getClass())) {
            topGoals.add(nextGoal);
            lastGoal = nextGoal;
        }
        return topGoals;
    }

    private TestFitnessFunction chooseRepresentativeGoal(TestCase test, Collection<TestFitnessFunction> goals) {
        LinkedHashMap<String, Integer> methodToPosition = new LinkedHashMap<String, Integer>();
        for (Statement st : test) {
            String name;
            if (st instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)st;
                name = ms.getMethodName() + ms.getDescriptor();
                methodToPosition.put(name, st.getPosition());
                continue;
            }
            if (!(st instanceof ConstructorStatement)) continue;
            ConstructorStatement cs = (ConstructorStatement)st;
            name = "<init>" + cs.getDescriptor();
            methodToPosition.put(name, st.getPosition());
        }
        TestFitnessFunction chosenGoal = goals.iterator().next();
        int chosenPosition = -1;
        for (TestFitnessFunction goal : goals) {
            int position;
            if (!methodToPosition.containsKey(goal.getTargetMethod()) || (position = ((Integer)methodToPosition.get(goal.getTargetMethod())).intValue()) < chosenPosition) continue;
            chosenPosition = position;
            chosenGoal = goal;
        }
        return chosenGoal;
    }

    private String getGoalName(TestFitnessFunction goal) {
        if (goal instanceof MethodCoverageTestFitness) {
            return this.getGoalName((MethodCoverageTestFitness)goal);
        }
        if (goal instanceof MethodCoverageTestFitness) {
            return this.getGoalName((MethodCoverageTestFitness)goal);
        }
        if (goal instanceof MethodNoExceptionCoverageTestFitness) {
            return this.getGoalName((MethodNoExceptionCoverageTestFitness)goal);
        }
        if (goal instanceof ExceptionCoverageTestFitness) {
            return this.getGoalName((ExceptionCoverageTestFitness)goal);
        }
        if (goal instanceof InputCoverageTestFitness) {
            return this.getGoalName((InputCoverageTestFitness)goal);
        }
        if (goal instanceof OutputCoverageTestFitness) {
            return this.getGoalName((OutputCoverageTestFitness)goal);
        }
        return this.formatMethodName(goal.getTargetClass(), goal.getTargetMethod());
    }

    private String getGoalName(MethodCoverageTestFitness goal) {
        return this.formatMethodName(goal.getClassName(), goal.getMethod());
    }

    private String getGoalName(MethodNoExceptionCoverageTestFitness goal) {
        return this.formatMethodName(goal.getClassName(), goal.getMethod());
    }

    private String getGoalName(ExceptionCoverageTestFitness goal) {
        Class<?> ex = goal.getExceptionClass();
        while (!Modifier.isPublic(ex.getModifiers()) || EvoSuiteMock.class.isAssignableFrom(ex) || ex.getCanonicalName().startsWith("com.sun.")) {
            ex = ex.getSuperclass();
        }
        if (goal.getTargetMethod().startsWith("<init>")) {
            return STR_CREATE_EXCEPTION + CoverageGoalTestNameGenerationStrategy.capitalize(this.getUniqueConstructorName(goal.getTargetClass(), goal.getTargetMethod())) + STR_THROWS + CoverageGoalTestNameGenerationStrategy.capitalize(ex.getSimpleName());
        }
        return this.formatMethodName(goal.getTargetClass(), goal.getTargetMethod()) + STR_THROWS + CoverageGoalTestNameGenerationStrategy.capitalize(ex.getSimpleName());
    }

    private String getGoalName(InputCoverageTestFitness goal) {
        String descriptor = goal.getValueDescriptor();
        return this.formatMethodName(goal.getClassName(), goal.getMethod()) + STR_WITH + this.formatValueDescriptor(descriptor);
    }

    private String getGoalName(OutputCoverageTestFitness goal) {
        String descriptor = goal.getValueDescriptor();
        return this.formatMethodName(goal.getClassName(), goal.getMethod()) + STR_RETURNS + this.formatValueDescriptor(descriptor);
    }

    private String formatValueDescriptor(String descriptor) {
        String[] components = descriptor.split(":");
        if (components.length == 1) {
            return CoverageGoalTestNameGenerationStrategy.capitalize(descriptor);
        }
        if (components.length == 2) {
            return CoverageGoalTestNameGenerationStrategy.capitalize(components[1]);
        }
        if (components.length == 3) {
            return CoverageGoalTestNameGenerationStrategy.capitalize(components[2]);
        }
        if (components.length == 4) {
            return CoverageGoalTestNameGenerationStrategy.capitalize(this.getShortClassName(components[1])) + STR_WHERE + CoverageGoalTestNameGenerationStrategy.capitalize(this.getMethodNameWithoutDescriptor(components[2])) + STR_IS + CoverageGoalTestNameGenerationStrategy.capitalize(components[3]);
        }
        throw new RuntimeException("Unsupported value descriptor: " + descriptor);
    }

    private String getGoalPairName(TestFitnessFunction goal1, TestFitnessFunction goal2) {
        if (goal1.getClass().equals(goal2.getClass())) {
            if (goal1 instanceof MethodCoverageTestFitness) {
                return this.getGoalPairName((MethodCoverageTestFitness)goal1, (MethodCoverageTestFitness)goal2);
            }
            if (goal1.getTargetClass().equals(goal2.getTargetClass()) && goal1.getTargetMethod().equals(goal2.getTargetMethod())) {
                if (goal1 instanceof InputCoverageTestFitness) {
                    return this.getGoalPairName((InputCoverageTestFitness)goal1, (InputCoverageTestFitness)goal2);
                }
                if (goal1 instanceof OutputCoverageTestFitness) {
                    return this.getGoalPairName((OutputCoverageTestFitness)goal1, (OutputCoverageTestFitness)goal2);
                }
            }
        }
        return this.getGoalName(goal1) + STR_AND + this.getGoalName(goal2);
    }

    private String getGoalPairName(MethodCoverageTestFitness goal1, MethodCoverageTestFitness goal2) {
        boolean isConstructor2;
        boolean isConstructor1 = goal1.getTargetMethod().startsWith("<init>");
        if (isConstructor1 != (isConstructor2 = goal2.getTargetMethod().startsWith("<init>"))) {
            if (isConstructor1) {
                return this.getGoalName(goal1) + "AndCalls" + this.getGoalName(goal2);
            }
            return this.getGoalName(goal2) + "AndCalls" + this.getGoalName(goal1);
        }
        return this.getGoalName(goal1) + STR_AND + this.getGoalName(goal2);
    }

    private String getGoalPairName(InputCoverageTestFitness goal1, InputCoverageTestFitness goal2) {
        return this.formatMethodName(goal1.getClassName(), goal1.getMethod()) + STR_WITH + this.formatValueDescriptor(goal1.getValueDescriptor()) + STR_AND + this.formatValueDescriptor(goal2.getValueDescriptor());
    }

    private String getGoalPairName(OutputCoverageTestFitness goal1, OutputCoverageTestFitness goal2) {
        return this.formatMethodName(goal1.getClassName(), goal1.getMethod()) + STR_RETURNS + this.formatValueDescriptor(goal1.getValueDescriptor()) + STR_AND + this.formatValueDescriptor(goal2.getValueDescriptor());
    }

    private String getShortClassName(String className) {
        int pos = className.lastIndexOf(".");
        if (pos >= 0) {
            return className.substring(pos + 1).replace("[]", "Array");
        }
        return className.replace("[]", "Array");
    }

    private String formatMethodName(String className, String method) {
        if (method.startsWith("<init>")) {
            String methodWithoutDescriptor = this.getMethodNameWithoutDescriptor(method);
            if (this.methodCount.containsKey(methodWithoutDescriptor) && this.methodCount.get(methodWithoutDescriptor).size() > 1) {
                return STR_CREATE + CoverageGoalTestNameGenerationStrategy.capitalize(this.getUniqueConstructorName(this.getShortClassName(className), method));
            }
            return STR_CREATE + CoverageGoalTestNameGenerationStrategy.capitalize(this.getShortClassName(className));
        }
        String methodWithoutDescriptor = this.getMethodNameWithoutDescriptor(method);
        if (this.methodCount.containsKey(methodWithoutDescriptor) && this.methodCount.get(methodWithoutDescriptor).size() > 1) {
            return CoverageGoalTestNameGenerationStrategy.capitalize(this.getUniqueMethodName(methodWithoutDescriptor, method));
        }
        return CoverageGoalTestNameGenerationStrategy.capitalize(methodWithoutDescriptor);
    }

    private String getUniqueMethodName(String methodNameWithoutDescriptor, String methodName) {
        if (!this.methodCount.containsKey(methodNameWithoutDescriptor)) {
            return methodNameWithoutDescriptor;
        }
        if (this.methodCount.get(methodNameWithoutDescriptor).size() == 1) {
            return methodNameWithoutDescriptor;
        }
        int pos = methodName.indexOf(40);
        if (pos < 0) {
            return methodName;
        }
        String descriptor = methodName.substring(pos);
        Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
        if (argumentTypes.length == 0) {
            return methodNameWithoutDescriptor + STR_WITHOUT + STR_ARGUMENTS;
        }
        if (argumentTypes.length == 1) {
            return methodNameWithoutDescriptor + STR_TAKING + CoverageGoalTestNameGenerationStrategy.capitalize(this.getShortClassName(argumentTypes[0].getClassName()));
        }
        HashSet otherMethods = new HashSet();
        otherMethods.addAll(this.methodCount.get(methodNameWithoutDescriptor));
        otherMethods.remove(methodName);
        boolean sameCardinality = false;
        for (String otherMethod : otherMethods) {
            String otherDesc = otherMethod.substring(otherMethod.indexOf(40));
            Type[] otherArgTypes = Type.getArgumentTypes((String)otherDesc);
            if (otherArgTypes.length != argumentTypes.length) continue;
            sameCardinality = true;
            break;
        }
        if (sameCardinality) {
            return methodNameWithoutDescriptor + STR_TAKING + this.getTypeArgumentsDescription(argumentTypes);
        }
        return methodNameWithoutDescriptor + STR_TAKING + argumentTypes.length + STR_ARGUMENTS;
    }

    private String getTypeArgumentsDescription(Type[] argumentTypes) {
        assert (argumentTypes.length > 1);
        LinkedHashMap<String, Integer> typeDescs = new LinkedHashMap<String, Integer>();
        for (Type t : argumentTypes) {
            String d = CoverageGoalTestNameGenerationStrategy.capitalize(this.getShortClassName(t.getClassName()));
            if (!typeDescs.containsKey(d)) {
                typeDescs.put(d, 1);
                continue;
            }
            typeDescs.put(d, (Integer)typeDescs.get(d) + 1);
        }
        StringBuilder builder = new StringBuilder();
        Object[] args = typeDescs.keySet().toArray();
        for (int i = 0; i < args.length; ++i) {
            String arg = (String)args[i];
            if (args.length > 1 && i == args.length - 1) {
                builder.append(STR_AND);
            }
            if ((Integer)typeDescs.get(arg) == 1) {
                builder.append(typeDescs.get(arg));
                continue;
            }
            builder.append(Integer.toString((Integer)typeDescs.get(arg)));
            builder.append(arg);
            builder.append('s');
        }
        return builder.toString();
    }

    private String getUniqueConstructorName(String className, String methodName) {
        if (!this.methodCount.containsKey("<init>")) {
            return this.getShortClassName(className);
        }
        if (this.methodCount.get("<init>").size() == 1) {
            return this.getShortClassName(className);
        }
        int pos = methodName.indexOf(40);
        if (pos < 0) {
            return this.getShortClassName(className);
        }
        String descriptor = methodName.substring(pos);
        Type[] argumentTypes = Type.getArgumentTypes((String)descriptor);
        if (argumentTypes.length == 0) {
            return this.getShortClassName(className) + STR_WITHOUT + STR_ARGUMENTS;
        }
        if (argumentTypes.length == 1) {
            return this.getShortClassName(className) + STR_TAKING + CoverageGoalTestNameGenerationStrategy.capitalize(this.getShortClassName(argumentTypes[0].getClassName()));
        }
        return this.getShortClassName(className) + STR_TAKING + argumentTypes.length + STR_ARGUMENTS;
    }

    private String getMethodNameWithoutDescriptor(String methodName) {
        int pos = methodName.indexOf(40);
        if (pos > 0) {
            return methodName.substring(0, pos);
        }
        return methodName;
    }

    public Comparator<TestCase> getComparator() {
        return new Comparator<TestCase>(){

            @Override
            public int compare(TestCase o1, TestCase o2) {
                return 0;
            }
        };
    }

    @Override
    public String getName(TestCase test) {
        return this.testToName.get(test);
    }
}

