/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.regression.RegressionAssertionGenerator;
import org.evosuite.regression.RegressionExceptionHelper;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.regression.RegressionTestSuiteChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionAssertionCounter {
    protected static final Logger logger = LoggerFactory.getLogger(RegressionAssertionCounter.class);
    private static Map<Integer, List<String>> assertionComments = new HashMap<Integer, List<String>>();

    public static int getNumAssertions(RegressionTestChromosome indvidiual) {
        RegressionTestSuiteChromosome chromosome = new RegressionTestSuiteChromosome();
        chromosome.addTest(indvidiual);
        return RegressionAssertionCounter.getNumAssertions(chromosome);
    }

    public static int getNumAssertions(RegressionTestSuiteChromosome individual) {
        assertionComments.clear();
        int numAssertions = RegressionAssertionCounter.getNumAssertions(individual, true);
        if (numAssertions > 0) {
            logger.debug("num assertions bigger than 0");
            ArrayList<TestCase> testCases = new ArrayList<TestCase>();
            testCases.addAll(individual.getTests());
            logger.debug("tests are copied");
            numAssertions = 0;
            JUnitAnalyzer.removeTestsThatDoNotCompile(testCases);
            logger.debug("... removeTestsThatDoNotCompile()");
            int numUnstable = JUnitAnalyzer.handleTestsThatAreUnstable(testCases);
            logger.debug("... handleTestsThatAreUnstable() = {}", (Object)numUnstable);
            if (testCases.size() > 0) {
                logger.debug("{} out of {} tests remaining!", (Object)testCases.size(), (Object)individual.getTests().size());
                numAssertions = RegressionAssertionCounter.getNumStableAssertions(testCases);
                logger.debug("Keeping {} assertions.", (Object)numAssertions);
            } else {
                logger.debug("ignored assertions. tests were removed.");
            }
        }
        return numAssertions;
    }

    private static int getNumStableAssertions(List<TestCase> testCases) {
        RegressionTestSuiteChromosome clone = new RegressionTestSuiteChromosome();
        for (TestCase t : testCases) {
            if (t.isUnstable()) {
                logger.debug("skipping unstable test...");
                continue;
            }
            RegressionTestChromosome rtc = new RegressionTestChromosome();
            TestChromosome tc = new TestChromosome();
            tc.setTestCase(t);
            rtc.setTest(tc);
            clone.addTest(rtc);
        }
        logger.debug("getting new num assertions ...");
        HashMap<Integer, List<String>> oldAssertionComments = new HashMap<Integer, List<String>>(assertionComments);
        assertionComments.clear();
        int numAssertions = RegressionAssertionCounter.getNumAssertions(clone, false);
        for (Map.Entry<Integer, List<String>> entry : assertionComments.entrySet()) {
            List<String> newAssertions = entry.getValue();
            List oldAssertions = (List)oldAssertionComments.get(entry.getKey());
            if (oldAssertions != null && newAssertions.equals(oldAssertions)) continue;
            numAssertions -= newAssertions.size();
        }
        if (numAssertions < 0) {
            numAssertions = 0;
            logger.error("We removed more assertions than expected");
        }
        return numAssertions;
    }

    public static int getNumAssertions(RegressionTestSuiteChromosome individual, Boolean removeAssertions) {
        return RegressionAssertionCounter.getNumAssertions(individual, removeAssertions, false);
    }

    public static int getNumAssertions(RegressionTestSuiteChromosome individual, Boolean removeAssertions, Boolean noExecution) {
        RegressionAssertionGenerator rgen = new RegressionAssertionGenerator();
        int oldTimeout = Properties.TIMEOUT;
        Properties.TIMEOUT *= 2;
        int totalCount = 0;
        logger.debug("Running assertion generator...");
        for (TestChromosome regressionTest : individual.getTestChromosomes()) {
            RegressionTestChromosome rtc = (RegressionTestChromosome)regressionTest;
            totalCount += RegressionAssertionCounter.checkForAssertions(removeAssertions, noExecution, rgen, rtc);
        }
        Properties.TIMEOUT = oldTimeout;
        if (totalCount > 0) {
            logger.warn("Assertions generated for the individual: " + totalCount);
        }
        return totalCount;
    }

    private static int checkForAssertions(Boolean removeAssertions, Boolean noExecution, RegressionAssertionGenerator assertionGenerator, RegressionTestChromosome regressionTest) {
        int totalCount = 0;
        if (!noExecution.booleanValue()) {
            ExecutionResult result1 = assertionGenerator.runTest(regressionTest.getTheTest().getTestCase());
            ExecutionResult result2 = assertionGenerator.runTest(regressionTest.getTheSameTestForTheOtherClassLoader().getTestCase());
            if (result1.test == null || result2.test == null || result1.hasTimeout() || result2.hasTimeout()) {
                logger.warn("=============================== HAD TIMEOUT ===============================");
            } else {
                int exceptionDiffs = RegressionExceptionHelper.compareExceptionDiffs(result1.getCopyOfExceptionMapping(), result2.getCopyOfExceptionMapping());
                if (exceptionDiffs > 0) {
                    logger.debug("Had {} different exceptions! ({})", (Object)exceptionDiffs, (Object)totalCount);
                }
                totalCount += exceptionDiffs;
                for (Class<?> observerClass : RegressionAssertionGenerator.observerClasses) {
                    if (result1.getTrace(observerClass) == null) continue;
                    result1.getTrace(observerClass).getAssertions(regressionTest.getTheTest().getTestCase(), result2.getTrace(observerClass));
                }
            }
        }
        int assertionCount = regressionTest.getTheTest().getTestCase().getAssertions().size();
        totalCount += assertionCount;
        if (assertionCount > 0) {
            List<Assertion> assertions = regressionTest.getTheTest().getTestCase().getAssertions();
            ArrayList<String> assertionComments = new ArrayList<String>();
            for (Assertion assertion : assertions) {
                logger.warn("+++++ Assertion: {} {}", (Object)assertion.getCode(), (Object)assertion.getComment());
                assertionComments.add(assertion.getComment());
            }
            RegressionAssertionCounter.assertionComments.put(regressionTest.getTheTest().getTestCase().toCode().hashCode(), assertionComments);
            if (assertions.size() == 0) {
                logger.warn("=========> NO ASSERTIONS!!!");
            } else {
                logger.warn("Assertions ^^^^^^^^^");
            }
        }
        if (removeAssertions.booleanValue()) {
            regressionTest.getTheTest().getTestCase().removeAssertions();
        }
        return totalCount;
    }
}

