/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.regression.ObjectFields;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegressionExecutionObserver
extends ExecutionObserver {
    private static final Logger logger = LoggerFactory.getLogger(RegressionExecutionObserver.class);
    List<Map<Integer, Map<String, Map<String, Object>>>> currentObjectMapPool = new ArrayList<Map<Integer, Map<String, Map<String, Object>>>>();
    List<Map<Integer, Map<String, Map<String, Object>>>> currentRegressionObjectMapPool = new ArrayList<Map<Integer, Map<String, Map<String, Object>>>>();
    private boolean isRegression = false;
    private boolean isDisabled = true;
    private List<List<Map<Integer, Map<String, Map<String, Object>>>>> objectMapPool = new ArrayList<List<Map<Integer, Map<String, Map<String, Object>>>>>();
    private List<List<Map<Integer, Map<String, Map<String, Object>>>>> regressionObjectMapPool = new ArrayList<List<Map<Integer, Map<String, Map<String, Object>>>>>();

    public void enable() {
        this.isDisabled = false;
    }

    public void disable() {
        this.isDisabled = true;
    }

    void setRegressionFlag(boolean isRegression) {
        this.isRegression = isRegression;
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
    }

    void resetObjPool() {
        this.currentObjectMapPool = new ArrayList<Map<Integer, Map<String, Map<String, Object>>>>();
        this.currentRegressionObjectMapPool = new ArrayList<Map<Integer, Map<String, Map<String, Object>>>>();
    }

    public void addToPools() {
        this.objectMapPool.add(this.currentObjectMapPool);
        this.regressionObjectMapPool.add(this.currentRegressionObjectMapPool);
    }

    public void addToPools(List<Map<Integer, Map<String, Map<String, Object>>>> currentObjectMapPool, List<Map<Integer, Map<String, Map<String, Object>>>> currentRegressionObjectMapPool) {
        this.objectMapPool.add(currentObjectMapPool);
        this.regressionObjectMapPool.add(currentRegressionObjectMapPool);
    }

    void clearPools() {
        this.objectMapPool = new ArrayList<List<Map<Integer, Map<String, Map<String, Object>>>>>();
        this.regressionObjectMapPool = new ArrayList<List<Map<Integer, Map<String, Map<String, Object>>>>>();
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope scope) {
        ObjectFields scopeObjectFields = new ObjectFields(scope);
        if (this.isDisabled) {
            return;
        }
        if (this.isRegression) {
            this.currentRegressionObjectMapPool.add(scopeObjectFields.getObjectVariables());
        } else {
            this.currentObjectMapPool.add(scopeObjectFields.getObjectVariables());
        }
    }

    @Override
    public void output(int position, String output) {
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void clear() {
    }
}

