/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.regression.RegressionMeasure;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;

public class RegressionFitnessHelper {
    static void trackDiversity(RegressionTestChromosome c, TestChromosome testChromosome) {
        HashMap<String, Map<Integer, String>> testDiversityMap = new HashMap<String, Map<Integer, String>>();
        for (int i = 0; i < testChromosome.getTestCase().size(); ++i) {
            String calledMethods;
            MethodStatement methodCall;
            VariableReference callee;
            Statement x = testChromosome.getTestCase().getStatement(i);
            if (!(x instanceof MethodStatement) || (callee = (methodCall = (MethodStatement)x).getCallee()) == null) continue;
            int calleePosition = callee.getStPosition();
            String calleeClass = callee.getClassName();
            String methodCallName = methodCall.getMethod().getName();
            HashMap<Integer, String> calleeMap = (HashMap<Integer, String>)testDiversityMap.get(calleeClass);
            if (calleeMap == null) {
                calleeMap = new HashMap<Integer, String>();
            }
            if ((calledMethods = (String)calleeMap.get(calleePosition)) == null) {
                calledMethods = "";
            }
            calledMethods = calledMethods + methodCallName;
            calleeMap.put(calleePosition, calledMethods);
            testDiversityMap.put(calleeClass, calleeMap);
        }
        c.diversityMap = testDiversityMap;
    }

    static boolean useMeasure(RegressionMeasure m) {
        boolean flag = false;
        if (m == Properties.REGRESSION_FITNESS) {
            return true;
        }
        switch (Properties.REGRESSION_FITNESS) {
            case COVERAGE_OLD: {
                if (m != RegressionMeasure.COVERAGE && m != RegressionMeasure.COVERAGE_OLD) break;
                return true;
            }
            case COVERAGE_NEW: {
                if (m != RegressionMeasure.COVERAGE && m != RegressionMeasure.COVERAGE_NEW) break;
                return true;
            }
            case STATE_DIFFERENCE: {
                if (m != RegressionMeasure.STATE_DIFFERENCE) break;
                flag = true;
                break;
            }
            case BRANCH_DISTANCE: {
                if (m != RegressionMeasure.BRANCH_DISTANCE || !Properties.REGRESSION_BRANCH_DISTANCE) break;
                flag = true;
                break;
            }
            case COVERAGE: {
                if (m != RegressionMeasure.COVERAGE && m != RegressionMeasure.COVERAGE_OLD && m != RegressionMeasure.COVERAGE_NEW) break;
                flag = true;
                break;
            }
            default: {
                if (m != RegressionMeasure.COVERAGE && m != RegressionMeasure.STATE_DIFFERENCE && (m != RegressionMeasure.BRANCH_DISTANCE || !Properties.REGRESSION_BRANCH_DISTANCE) && m != RegressionMeasure.COVERAGE_OLD && m != RegressionMeasure.COVERAGE_NEW) break;
                flag = true;
            }
        }
        return flag;
    }

    private static class LRS {
        private LRS() {
        }

        public String lcp(String s, String t) {
            int n = Math.min(s.length(), t.length());
            for (int i = 0; i < n; ++i) {
                if (s.charAt(i) == t.charAt(i)) continue;
                return s.substring(0, i);
            }
            return s.substring(0, n);
        }

        public String lrs(String s) {
            int N = s.length();
            Object[] suffixes = new String[N];
            for (int i = 0; i < N; ++i) {
                suffixes[i] = s.substring(i, N);
            }
            Arrays.sort(suffixes);
            String lrs = "";
            for (int i = 0; i < N - 1; ++i) {
                String x = this.lcp((String)suffixes[i], (String)suffixes[i + 1]);
                if (x.length() <= lrs.length()) continue;
                lrs = x;
            }
            return lrs;
        }
    }
}

