/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.regression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.regression.ObjectDistanceCalculator;
import org.evosuite.regression.RegressionExecutionObserver;
import org.evosuite.regression.RegressionFitnessHelper;
import org.evosuite.regression.RegressionMeasure;
import org.evosuite.regression.RegressionTestChromosome;
import org.evosuite.regression.RegressionTestSuiteChromosome;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.MethodCall;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class RegressionSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -1979463801167353053L;
    private Map<String, Map<Integer, String>> diversityMap = new HashMap<String, Map<Integer, String>>();
    private int maxBranchFitnessValueO = 0;
    private int maxBranchFitnessValueR = 0;
    private Map<Integer, Integer> branchIdMap = new HashMap<Integer, Integer>();
    private transient RegressionExecutionObserver observer;
    private BranchCoverageSuiteFitness bcFitness;
    private BranchCoverageSuiteFitness bcFitnessRegression;
    private Map<Integer, Double> branchDistanceMap;
    private double bestFitness = Double.MAX_VALUE;
    private HashMap<Integer, Double> tempBranchDistanceMap;
    private int uniqueCalls;

    public RegressionSuiteFitness() {
        logger.warn("### initialising Regression-GA... ###");
        this.initBranchMap();
        try {
            TestGenerationContext.getInstance().getRegressionClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.bcFitness = new BranchCoverageSuiteFitness();
        this.bcFitnessRegression = new BranchCoverageSuiteFitness(TestGenerationContext.getInstance().getRegressionClassLoaderForSUT());
        this.maxBranchFitnessValueO = this.bcFitness.getMaxValue();
        this.maxBranchFitnessValueR = this.bcFitnessRegression.getMaxValue();
        this.observer = new RegressionExecutionObserver();
        ExecutionTracer.enableTraceCalls();
    }

    private void initBranchMap() {
        this.tempBranchDistanceMap = new HashMap();
        double maxBranchValue = 4.0;
        for (Branch b : BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllBranches()) {
            this.tempBranchDistanceMap.put(b.getActualBranchId(), maxBranchValue);
        }
    }

    private void executeChangedTestsAndUpdateResults(AbstractTestSuiteChromosome<? extends ExecutableChromosome> changedSuite) {
        this.observer.clearPools();
        this.diversityMap.clear();
        RegressionTestSuiteChromosome suite = (RegressionTestSuiteChromosome)changedSuite;
        for (TestChromosome chromosome : suite.getTestChromosomes()) {
            RegressionTestChromosome c = (RegressionTestChromosome)chromosome;
            this.observer.enable();
            this.observer.resetObjPool();
            this.observer.setRegressionFlag(false);
            TestChromosome testChromosome = c.getTheTest();
            TestChromosome otherChromosome = c.getTheSameTestForTheOtherClassLoader();
            if (testChromosome.isChanged() || testChromosome.getLastExecutionResult() == null) {
                double objectDistance;
                if (Properties.REGRESSION_DIVERSITY) {
                    RegressionFitnessHelper.trackDiversity(c, testChromosome);
                }
                ExecutionResult result = TestCaseExecutor.runTest(testChromosome.getTestCase());
                this.observer.setRegressionFlag(true);
                ExecutionResult otherResult = TestCaseExecutor.runTest(otherChromosome.getTestCase());
                this.observer.setRegressionFlag(false);
                this.observer.disable();
                result.regressionObjectDistance = objectDistance = this.getTestObjectDistance(this.observer.currentObjectMapPool, this.observer.currentRegressionObjectMapPool);
                otherResult.regressionObjectDistance = objectDistance;
                testChromosome.setLastExecutionResult(result);
                testChromosome.setChanged(false);
                otherChromosome.setLastExecutionResult(otherResult);
                otherChromosome.setChanged(false);
            }
            if (!Properties.REGRESSION_DIVERSITY) continue;
            this.measureDiversity(c);
        }
    }

    private void measureDiversity(RegressionTestChromosome c) {
        for (Map.Entry<String, Map<Integer, String>> dEntry : c.diversityMap.entrySet()) {
            Map<Integer, String> divInstance = this.diversityMap.get(dEntry.getKey());
            if (divInstance == null) {
                this.diversityMap.put(dEntry.getKey(), dEntry.getValue());
                continue;
            }
            Map<Integer, String> testMethodCalls = dEntry.getValue();
            for (Map.Entry<Integer, String> mc : testMethodCalls.entrySet()) {
                String calls = divInstance.get(mc.getKey());
                if (calls == null || calls.length() < mc.getValue().length()) {
                    calls = mc.getValue();
                }
                divInstance.put(mc.getKey(), calls);
            }
        }
    }

    @Override
    public double getFitness(AbstractTestSuiteChromosome<? extends ExecutableChromosome> individual) {
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.STATE_DIFFERENCE)) {
            TestCaseExecutor.getInstance().addObserver(this.observer);
            this.observer.clearPools();
        }
        double distance = 0.0;
        double fitness = 0.0;
        this.branchDistanceMap = (Map)this.tempBranchDistanceMap.clone();
        int numDifferentExceptions = 0;
        int totalExceptions = 0;
        this.executeChangedTestsAndUpdateResults(individual);
        RegressionTestSuiteChromosome suite = (RegressionTestSuiteChromosome)individual;
        ArrayList<Double> objectDistances = new ArrayList<Double>();
        for (TestChromosome regressionTest : suite.getTestChromosomes()) {
            RegressionTestChromosome rtc = (RegressionTestChromosome)regressionTest;
            ExecutionResult result1 = rtc.getTheTest().getLastExecutionResult();
            ExecutionResult result2 = rtc.getTheSameTestForTheOtherClassLoader().getLastExecutionResult();
            int numExceptionOrig = result1.getNumberOfThrownExceptions();
            int numExceptionReg = result2.getNumberOfThrownExceptions();
            double exDiff = Math.abs((double)(numExceptionOrig - numExceptionReg));
            totalExceptions += numExceptionOrig + numExceptionReg;
            numDifferentExceptions = (int)((double)numDifferentExceptions + exDiff);
            if (RegressionFitnessHelper.useMeasure(RegressionMeasure.BRANCH_DISTANCE)) {
                this.getBranchDistance(result1.getTrace().getMethodCalls(), result2.getTrace().getMethodCalls());
            }
            objectDistances.add(result1.regressionObjectDistance);
        }
        double objectDistanceFitness = 0.0;
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.STATE_DIFFERENCE)) {
            if (!objectDistances.isEmpty()) {
                distance = (Double)Collections.max(objectDistances);
            }
            objectDistanceFitness = 1.0 / (1.0 + distance) * (double)(this.maxBranchFitnessValueO + this.maxBranchFitnessValueR);
        }
        AbstractTestSuiteChromosome<TestChromosome> testSuiteChromosome = suite.getTestSuite();
        AbstractTestSuiteChromosome<TestChromosome> testRegressionSuiteChromosome = null;
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.COVERAGE_NEW)) {
            testRegressionSuiteChromosome = suite.getTestSuiteForTheOtherClassLoader();
        }
        double coverageOld = 0.0;
        double coverageNew = 0.0;
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.COVERAGE_OLD)) {
            coverageOld = this.bcFitness.getFitness(testSuiteChromosome);
        }
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.COVERAGE_NEW)) {
            coverageNew = this.bcFitnessRegression.getFitness(testRegressionSuiteChromosome);
        }
        double coverage = coverageOld + coverageNew;
        double branchDistanceFitness = 0.0;
        double totalBranchDistanceFitness = 0.0;
        if (RegressionFitnessHelper.useMeasure(RegressionMeasure.BRANCH_DISTANCE)) {
            for (Map.Entry<Integer, Double> branch : this.branchDistanceMap.entrySet()) {
                totalBranchDistanceFitness += branch.getValue().doubleValue();
            }
            branchDistanceFitness = totalBranchDistanceFitness;
        }
        switch (Properties.REGRESSION_FITNESS) {
            case COVERAGE_OLD: {
                fitness += coverageOld;
                break;
            }
            case COVERAGE_NEW: {
                fitness += coverageNew;
                break;
            }
            case BRANCH_DISTANCE: {
                fitness += branchDistanceFitness;
                break;
            }
            case STATE_DIFFERENCE: {
                fitness += objectDistanceFitness;
                break;
            }
            case COVERAGE: {
                fitness += coverage;
                break;
            }
            default: {
                fitness += coverage;
                fitness += branchDistanceFitness;
                fitness += objectDistanceFitness;
            }
        }
        double exceptionDistance = 1.0 / (1.0 + (double)numDifferentExceptions);
        fitness += exceptionDistance;
        if (Properties.REGRESSION_DIVERSITY) {
            this.calculateDiversity();
            double diversityFitness = 1.0 / (1.0 + (double)this.uniqueCalls);
            fitness += diversityFitness;
        }
        individual.setCoverage(this, (this.bcFitness.totalCovered + this.bcFitnessRegression.totalCovered) / 2.0);
        this.updateIndividual(this, individual, fitness);
        if (fitness < this.bestFitness) {
            this.bestFitness = fitness;
            logger.warn("OBJ distance: " + distance + " - fitness:" + fitness + " - branchDistance:" + totalBranchDistanceFitness + " - coverage:" + coverage + " - ex: " + numDifferentExceptions + " - tex: " + totalExceptions);
            logger.warn("Best Fitness " + fitness + ", number of tests: " + testSuiteChromosome.size() + ", total length: " + testSuiteChromosome.totalLengthOfTestCases());
        }
        return fitness;
    }

    private void calculateDiversity() {
        this.uniqueCalls = 0;
        for (Map.Entry<String, Map<Integer, String>> dEntry : this.diversityMap.entrySet()) {
            Map<Integer, String> calleeObjects = this.diversityMap.get(dEntry.getKey());
            for (Map.Entry<Integer, String> mCall : calleeObjects.entrySet()) {
                boolean alreadyPresent = false;
                for (int position : calleeObjects.keySet()) {
                    if (position == mCall.getKey() || !calleeObjects.get(position).contains(mCall.getValue())) continue;
                    alreadyPresent = true;
                    break;
                }
                if (alreadyPresent) continue;
                ++this.uniqueCalls;
            }
        }
    }

    private void getBranchDistance(List<MethodCall> methodCallsOrig, List<MethodCall> methodCallsReg) {
        int i = 0;
        int j = 0;
        while (i < methodCallsOrig.size() && j < methodCallsReg.size()) {
            MethodCall mO = methodCallsOrig.get(i);
            MethodCall mR = methodCallsReg.get(j);
            if (mO.methodName.equals(mR.methodName)) {
                List<Integer> branchesO = mO.branchTrace;
                List<Integer> branchesR = mR.branchTrace;
                int k = 0;
                int l = 0;
                while (k < branchesO.size() && l < branchesR.size()) {
                    Integer branchO = branchesO.get(k);
                    Integer branchR = branchesR.get(l);
                    if (Properties.REGRESSION_DIFFERENT_BRANCHES) {
                        logger.error("Regression_differrent_branches has been deprecated and removed from Evosuite. Please disable the property and try again");
                        if (this.branchIdMap.containsKey(branchO)) {
                            branchR = this.branchIdMap.get(branchO);
                        } else {
                            if (Objects.equals(branchO, branchR)) {
                                ++k;
                            }
                            ++l;
                            continue;
                        }
                    }
                    if (!Objects.equals(branchO, branchR)) break;
                    double trueDisO = RegressionSuiteFitness.normalize(mO.trueDistanceTrace.get(k));
                    double trueDisR = RegressionSuiteFitness.normalize(mR.trueDistanceTrace.get(l));
                    double falseDisO = RegressionSuiteFitness.normalize(mO.falseDistanceTrace.get(k));
                    double falseDisR = RegressionSuiteFitness.normalize(mR.falseDistanceTrace.get(l));
                    double tempBranchDistance = 2.0 * (1.0 - (Math.abs(trueDisO - trueDisR) + Math.abs(falseDisO - falseDisR)));
                    tempBranchDistance += (Math.abs(trueDisR) + Math.abs(falseDisR)) / 2.0;
                    tempBranchDistance += (Math.abs(trueDisO) + Math.abs(falseDisO)) / 2.0;
                    if (trueDisO == 0.0 && falseDisR == 0.0 || falseDisO == 0.0 && trueDisR == 0.0) {
                        tempBranchDistance = 0.0;
                    }
                    if (!this.branchDistanceMap.containsKey(branchO) || this.branchDistanceMap.get(branchO) > tempBranchDistance) {
                        this.branchDistanceMap.put(branchO, tempBranchDistance);
                    }
                    ++k;
                    ++l;
                }
                ++i;
                ++j;
                continue;
            }
            if (mO.callDepth == 1 && mR.callDepth > 1) {
                ++j;
                continue;
            }
            if (mR.callDepth == 1 && mO.callDepth > 1) {
                ++i;
                continue;
            }
            ++i;
            ++j;
        }
    }

    private double getTestObjectDistance(List<Map<Integer, Map<String, Map<String, Object>>>> originalMap, List<Map<Integer, Map<String, Map<String, Object>>>> regressionMap) {
        ObjectDistanceCalculator distanceCalculator = new ObjectDistanceCalculator();
        double distance = 0.0;
        HashMap<String, Double> maxClassDistance = new HashMap<String, Double>();
        for (int j = 0; j < originalMap.size(); ++j) {
            Map<Integer, Map<String, Map<String, Object>>> map1 = originalMap.get(j);
            if (regressionMap.size() <= j) continue;
            Map<Integer, Map<String, Map<String, Object>>> map2 = regressionMap.get(j);
            for (Map.Entry<Integer, Map<String, Map<String, Object>>> map1_entry : map1.entrySet()) {
                Map<String, Map<String, Object>> map1_values = map1_entry.getValue();
                Map<String, Map<String, Object>> map2_values = map2.get(map1_entry.getKey());
                if (map1_values == null || map2_values == null) continue;
                for (Map.Entry<String, Map<String, Object>> internal_map1_entries : map1_values.entrySet()) {
                    Map<String, Object> map1_value = internal_map1_entries.getValue();
                    Map<String, Object> map2_value = map2_values.get(internal_map1_entries.getKey());
                    if (map1_value == null || map2_value == null) continue;
                    double objectDistance = distanceCalculator.getObjectMapDistance(map1_value, map2_value);
                    if (maxClassDistance.containsKey(internal_map1_entries.getKey()) && !((Double)maxClassDistance.get(internal_map1_entries.getKey()) < objectDistance)) continue;
                    maxClassDistance.put(internal_map1_entries.getKey(), objectDistance);
                }
            }
        }
        double tmpDistance = 0.0;
        switch (Properties.REGRESSION_ANALYSIS_OBJECTDISTANCE) {
            case 4: {
                tmpDistance = (Double)Collections.max(maxClassDistance.values());
                break;
            }
            case 5: {
                if (maxClassDistance.size() <= 0) break;
                tmpDistance /= (double)maxClassDistance.size();
                break;
            }
            case 6: {
                tmpDistance = (Double)Collections.min(maxClassDistance.values());
                break;
            }
            default: {
                for (Map.Entry maxEntry : maxClassDistance.entrySet()) {
                    tmpDistance += ((Double)maxEntry.getValue()).doubleValue();
                }
            }
        }
        distance += tmpDistance;
        return distance += (double)distanceCalculator.getNumDifferentVariables();
    }

    @Override
    public boolean isMaximizationFunction() {
        return false;
    }
}

