/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.setup.ConcreteClassAnalyzer;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.TestCluster;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CastClassManager {
    private static CastClassManager instance = new CastClassManager();
    private static final Logger logger = LoggerFactory.getLogger(CastClassManager.class);
    private final Map<GenericClass, Integer> classMap = new LinkedHashMap<GenericClass, Integer>();
    private final List<Class<?>> specialCases = Arrays.asList(Comparable.class, Comparator.class, Iterable.class, Enum.class);

    public static List<GenericClass> sortByValue(Map<GenericClass, Integer> map) {
        LinkedList<Map.Entry<GenericClass, Integer>> list = new LinkedList<Map.Entry<GenericClass, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<GenericClass, Integer>>(){

            @Override
            public int compare(Map.Entry<GenericClass, Integer> o1, Map.Entry<GenericClass, Integer> o2) {
                if (o1.getKey().getNumParameters() == o2.getKey().getNumParameters()) {
                    return o1.getValue().compareTo(o2.getValue());
                }
                return o1.getKey().getNumParameters() - o2.getKey().getNumParameters();
            }
        });
        LinkedList<GenericClass> result = new LinkedList<GenericClass>();
        for (Map.Entry entry : list) {
            result.add((GenericClass)entry.getKey());
        }
        return result;
    }

    public static GenericClass selectClass(List<GenericClass> candidates) {
        double r = Randomness.nextDouble();
        double d = Properties.RANK_BIAS - Math.sqrt(Properties.RANK_BIAS * Properties.RANK_BIAS - 4.0 * (Properties.RANK_BIAS - 1.0) * r);
        int length = candidates.size();
        d = d / 2.0 / (Properties.RANK_BIAS - 1.0);
        int index = (int)((double)length * d);
        return candidates.get(index);
    }

    private CastClassManager() {
        this.initDefaultClasses();
    }

    private void initDefaultClasses() {
        this.classMap.put(new GenericClass(Object.class), 0);
        this.classMap.put(new GenericClass(String.class), 1);
        this.classMap.put(new GenericClass(Integer.class), 1);
    }

    public static CastClassManager getInstance() {
        return instance;
    }

    public void addCastClass(String className, int depth) {
        try {
            Class<?> clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(className);
            GenericClass castClazz = new GenericClass(clazz);
            this.addCastClass(castClazz.getWithWildcardTypes(), depth);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Error including cast class " + className + " because: " + e);
        }
    }

    public void addCastClass(Type type, int depth) {
        GenericClass castClazz = new GenericClass(type);
        this.addCastClass(castClazz.getWithWildcardTypes(), depth);
    }

    public void addCastClass(GenericClass clazz, int depth) {
        if (clazz.getRawClass() == null) {
            logger.warn("ADDING NULL!");
            assert (false);
        }
        if (clazz.isAbstract()) {
            for (Class<?> concreteClass : ConcreteClassAnalyzer.getInstance().getConcreteClasses(clazz.getRawClass(), TestCluster.getInheritanceTree())) {
                GenericClass c = new GenericClass(concreteClass);
                if (!TestUsageChecker.canUse(c.getRawClass())) continue;
                this.classMap.put(c, depth);
            }
            if (Properties.P_FUNCTIONAL_MOCKING > 0.0 && TestUsageChecker.canUse(clazz.getRawClass())) {
                this.classMap.put(clazz, depth);
            }
        } else if (TestUsageChecker.canUse(clazz.getRawClass())) {
            this.classMap.put(clazz, depth);
        }
    }

    private void handleComparable() {
    }

    private void handleComparator() {
    }

    private void handleEnum() {
    }

    private void handleIterable() {
    }

    private boolean isSpecialCase(TypeVariable<?> typeVariable) {
        for (Type bound : typeVariable.getBounds()) {
            Class clazz = GenericTypeReflector.erase((Type)bound);
            if (!this.specialCases.contains(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isSpecialCase(WildcardType wildcardType) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addAssignableClass(WildcardType wildcardType, Map<TypeVariable<?>, Type> typeMap) {
        Set<Class<?>> classes = TestCluster.getInstance().getAnalyzedClasses();
        LinkedHashSet assignableClasses = new LinkedHashSet();
        for (Class<?> clazz : classes) {
            if (!TestUsageChecker.canUse(clazz)) continue;
            GenericClass genericClass = new GenericClass(clazz).getWithWildcardTypes();
            if (!genericClass.satisfiesBoundaries(wildcardType, typeMap)) {
                logger.debug("Not assignable: " + clazz);
                continue;
            }
            logger.debug("Assignable");
            assignableClasses.add(clazz);
        }
        for (Type t : typeMap.values()) {
            Class clazz;
            if (t instanceof WildcardType || !TestUsageChecker.canUse(GenericTypeReflector.erase((Type)(clazz = GenericTypeReflector.erase((Type)t))))) continue;
            GenericClass genericClass = new GenericClass(clazz).getWithWildcardTypes();
            if (!genericClass.satisfiesBoundaries(wildcardType, typeMap)) {
                logger.debug("Not assignable: " + clazz);
                continue;
            }
            logger.debug("Assignable");
            assignableClasses.add(clazz);
        }
        for (Iterator<Type> iterator : wildcardType.getUpperBounds()) {
            void var8_15;
            if (typeMap.containsKey(iterator)) {
                Type type = typeMap.get(iterator);
            }
            Class clazz = GenericTypeReflector.erase((Type)var8_15);
            logger.debug("Checking bound: " + var8_15);
            if (!TestUsageChecker.canUse(clazz)) continue;
            GenericClass genericClass = new GenericClass((Type)var8_15);
            if (genericClass.hasTypeVariables()) {
                logger.debug("Has type variables: " + genericClass);
                GenericClass wildcardClass = genericClass.getWithWildcardTypes();
                if (!wildcardClass.satisfiesBoundaries(wildcardType, typeMap)) {
                    logger.debug("Not assignable: " + clazz);
                    continue;
                }
                logger.debug("Assignable");
                assignableClasses.add(clazz);
                continue;
            }
            logger.debug("Adding directly: " + genericClass);
            assignableClasses.add(genericClass.getRawClass());
            this.classMap.put(genericClass, 10);
        }
        logger.debug("Found assignable classes for wildcardtype " + wildcardType + ": " + assignableClasses.size());
        if (!assignableClasses.isEmpty()) {
            Class clazz = (Class)Randomness.choice(assignableClasses);
            GenericClass castClass = new GenericClass(clazz);
            logger.debug("Adding cast class " + castClass);
            this.classMap.put(castClass, 10);
            return true;
        }
        return false;
    }

    private boolean addAssignableClass(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> typeMap) {
        Object clazz;
        Set<Class<?>> classes = TestCluster.getInstance().getAnalyzedClasses();
        LinkedHashSet<Object> assignableClasses = new LinkedHashSet<Object>();
        for (Class<?> clazz2 : classes) {
            if (!TestUsageChecker.canUse(clazz2)) continue;
            GenericClass genericClass = new GenericClass(clazz2).getWithWildcardTypes();
            if (!genericClass.satisfiesBoundaries(typeVariable, typeMap)) {
                logger.debug("Not assignable: " + clazz2);
                continue;
            }
            logger.debug("Assignable");
            assignableClasses.add(clazz2);
        }
        for (Type t : typeMap.values()) {
            if (t instanceof WildcardType || !TestUsageChecker.canUse(GenericTypeReflector.erase((Type)(clazz = GenericTypeReflector.erase((Type)t))))) continue;
            GenericClass genericClass = new GenericClass((Class<?>)clazz).getWithWildcardTypes();
            if (!genericClass.satisfiesBoundaries(typeVariable, typeMap)) {
                logger.debug("Not assignable: " + clazz);
                continue;
            }
            logger.debug("Assignable");
            assignableClasses.add(clazz);
        }
        logger.debug("Found assignable classes for type variable " + typeVariable + ": " + assignableClasses.size());
        if (!assignableClasses.isEmpty()) {
            Class clazz3 = (Class)Randomness.choice(assignableClasses);
            GenericClass castClass = new GenericClass(clazz3);
            logger.debug("Adding cast class " + castClass);
            this.classMap.put(castClass, 10);
            return true;
        }
        InheritanceTree inheritanceTree = DependencyAnalysis.getInheritanceTree();
        LinkedHashSet boundCandidates = new LinkedHashSet();
        for (Type bound : typeVariable.getBounds()) {
            Class rawBound = GenericTypeReflector.erase((Type)bound);
            boundCandidates.add(rawBound);
            logger.debug("Getting concrete classes for " + rawBound);
            boundCandidates.addAll(ConcreteClassAnalyzer.getInstance().getConcreteClasses(rawBound, inheritanceTree));
        }
        for (Class clazz2 : boundCandidates) {
            if (!TestUsageChecker.canUse(clazz2)) continue;
            boolean isAssignable = true;
            for (Type bound : typeVariable.getBounds()) {
                if (GenericTypeReflector.erase((Type)bound).equals(Enum.class) && clazz2.isEnum()) continue;
                if (!GenericClass.isAssignable(bound, clazz2)) {
                    isAssignable = false;
                    logger.debug("Not assignable: " + clazz2 + " to bound " + bound);
                    break;
                }
                if (!(bound instanceof ParameterizedType) || !Arrays.asList(((ParameterizedType)bound).getActualTypeArguments()).contains(typeVariable)) continue;
                isAssignable = false;
                break;
            }
            if (!isAssignable) continue;
            assignableClasses.add(clazz2);
        }
        logger.debug("After adding bounds, found " + assignableClasses.size() + " assignable classes for type variable " + typeVariable + ": " + assignableClasses);
        if (!assignableClasses.isEmpty()) {
            clazz = (Class)Randomness.choice(assignableClasses);
            GenericClass genericClass = new GenericClass((Class<?>)clazz);
            logger.debug("Adding cast class " + genericClass);
            this.classMap.put(genericClass, 10);
            return true;
        }
        return false;
    }

    private List<GenericClass> getAssignableClasses(WildcardType wildcardType, boolean allowRecursion, Map<TypeVariable<?>, Type> ownerVariableMap) {
        LinkedHashMap<GenericClass, Integer> assignableClasses = new LinkedHashMap<GenericClass, Integer>();
        logger.debug("Getting assignable classes for wildcard type " + wildcardType);
        for (Map.Entry<GenericClass, Integer> entry : this.classMap.entrySet()) {
            GenericClass key = entry.getKey();
            logger.debug("Current class for wildcard " + wildcardType + ": " + key);
            if (!key.satisfiesBoundaries(wildcardType, ownerVariableMap)) {
                logger.debug("Does not satisfy boundaries");
                continue;
            }
            if (!allowRecursion && key.hasWildcardOrTypeVariables()) {
                logger.debug("Stopping because of type recursion");
                continue;
            }
            logger.debug("Is assignable");
            assignableClasses.put(entry.getKey(), entry.getValue());
        }
        return CastClassManager.sortByValue(assignableClasses);
    }

    private List<GenericClass> getAssignableClasses(TypeVariable<?> typeVariable, boolean allowRecursion, Map<TypeVariable<?>, Type> ownerVariableMap) {
        LinkedHashMap<GenericClass, Integer> assignableClasses = new LinkedHashMap<GenericClass, Integer>();
        logger.debug("Getting assignable classes for type variable " + typeVariable);
        for (Map.Entry<GenericClass, Integer> entry : this.classMap.entrySet()) {
            GenericClass key = entry.getKey();
            logger.debug("Current class for type variable " + typeVariable + ": " + key);
            if (!key.satisfiesBoundaries(typeVariable, ownerVariableMap)) {
                logger.debug("Bounds not satisfied");
                continue;
            }
            if (!allowRecursion && key.hasWildcardOrTypeVariables()) {
                logger.debug("Recursion not allowed but type has wildcard or type variables");
                continue;
            }
            assignableClasses.put(entry.getKey(), entry.getValue());
        }
        logger.debug("Found assignable classes: " + assignableClasses.size());
        return CastClassManager.sortByValue(assignableClasses);
    }

    public GenericClass selectCastClass() {
        List<GenericClass> assignableClasses = CastClassManager.sortByValue(this.classMap);
        return CastClassManager.selectClass(assignableClasses);
    }

    public GenericClass selectCastClass(TypeVariable<?> typeVariable, boolean allowRecursion, Map<TypeVariable<?>, Type> ownerVariableMap) {
        List<GenericClass> assignableClasses = this.getAssignableClasses(typeVariable, allowRecursion, ownerVariableMap);
        logger.debug("Assignable classes to " + typeVariable + ": " + assignableClasses);
        if (assignableClasses.isEmpty()) {
            logger.debug("Trying to add new cast class");
            if (this.addAssignableClass(typeVariable, ownerVariableMap)) {
                logger.debug("Now trying again to get a class");
                assignableClasses = this.getAssignableClasses(typeVariable, allowRecursion, ownerVariableMap);
                if (assignableClasses.isEmpty()) {
                    logger.debug("Nothing is assignable");
                    return null;
                }
            } else {
                logger.debug("Nothing is assignable");
                return null;
            }
        }
        logger.debug("Now we've got assignable classes: " + assignableClasses.size());
        return CastClassManager.selectClass(assignableClasses);
    }

    public GenericClass selectCastClass(WildcardType wildcardType, boolean allowRecursion, Map<TypeVariable<?>, Type> ownerVariableMap) throws ConstructionFailedException {
        logger.debug("Getting assignable classes for wildcard");
        List<GenericClass> assignableClasses = this.getAssignableClasses(wildcardType, false, ownerVariableMap);
        logger.debug("Assignable classes to " + wildcardType + ": " + assignableClasses);
        if (assignableClasses.isEmpty() && allowRecursion) {
            assignableClasses.addAll(this.getAssignableClasses(wildcardType, allowRecursion, ownerVariableMap));
        }
        if (assignableClasses.isEmpty()) {
            logger.debug("Trying to add new cast class");
            if (this.addAssignableClass(wildcardType, ownerVariableMap)) {
                assignableClasses = this.getAssignableClasses(wildcardType, allowRecursion, ownerVariableMap);
                if (assignableClasses.isEmpty()) {
                    logger.debug("Nothing is assignable");
                    throw new ConstructionFailedException("Nothing is assignable to " + wildcardType);
                }
            } else {
                logger.debug("Making random choice because nothing is assignable");
                throw new ConstructionFailedException("Nothing is assignable to " + wildcardType);
            }
        }
        return CastClassManager.selectClass(assignableClasses);
    }

    public boolean hasClass(String className) {
        for (GenericClass clazz : this.classMap.keySet()) {
            if (!clazz.getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public Set<GenericClass> getCastClasses() {
        return this.classMap.keySet();
    }

    public void clear() {
        this.classMap.clear();
        this.initDefaultClasses();
    }
}

