/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.FrequencyBasedRandomAccessQueue;
import org.evosuite.utils.RandomAccessQueue;
import org.objectweb.asm.Type;

public class DynamicConstantVariableProbabilityPool
implements ConstantPool {
    private final RandomAccessQueue<String> stringPool = new FrequencyBasedRandomAccessQueue<String>();
    private final RandomAccessQueue<Type> typePool = new FrequencyBasedRandomAccessQueue<Type>();
    private final RandomAccessQueue<Integer> intPool = new FrequencyBasedRandomAccessQueue<Integer>();
    private final RandomAccessQueue<Double> doublePool = new FrequencyBasedRandomAccessQueue<Double>();
    private final RandomAccessQueue<Long> longPool = new FrequencyBasedRandomAccessQueue<Long>();
    private final RandomAccessQueue<Float> floatPool = new FrequencyBasedRandomAccessQueue<Float>();

    public DynamicConstantVariableProbabilityPool() {
        this.stringPool.restrictedAdd("");
        if (Properties.TARGET_CLASS != null && !Properties.TARGET_CLASS.isEmpty()) {
            this.typePool.restrictedAdd(Type.getObjectType((String)Properties.TARGET_CLASS));
        } else {
            this.typePool.restrictedAdd(Type.getType(Object.class));
        }
        this.intPool.restrictedAdd(0);
        this.longPool.restrictedAdd(0L);
        this.floatPool.restrictedAdd(Float.valueOf(0.0f));
        this.doublePool.restrictedAdd(0.0);
    }

    @Override
    public String getRandomString() {
        return this.stringPool.getRandomValue();
    }

    @Override
    public Type getRandomType() {
        return this.typePool.getRandomValue();
    }

    @Override
    public int getRandomInt() {
        return this.intPool.getRandomValue();
    }

    @Override
    public float getRandomFloat() {
        return this.floatPool.getRandomValue().floatValue();
    }

    @Override
    public double getRandomDouble() {
        return this.doublePool.getRandomValue();
    }

    @Override
    public long getRandomLong() {
        return this.longPool.getRandomValue();
    }

    @Override
    public void add(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() > Properties.MAX_STRING) {
                return;
            }
            if (string.length() > 65535) {
                return;
            }
            this.stringPool.restrictedAdd(string);
        } else if (object instanceof Type) {
            this.typePool.restrictedAdd((Type)object);
        } else if (object instanceof Integer) {
            if (Properties.RESTRICT_POOL) {
                int val = (Integer)object;
                if (Math.abs(val) < Properties.MAX_INT) {
                    this.intPool.restrictedAdd((Integer)object);
                }
            } else {
                this.intPool.restrictedAdd((Integer)object);
            }
        } else if (object instanceof Long) {
            if (Properties.RESTRICT_POOL) {
                long val = (Long)object;
                if (Math.abs(val) < (long)Properties.MAX_INT) {
                    this.longPool.restrictedAdd((Long)object);
                }
            } else {
                this.longPool.restrictedAdd((Long)object);
            }
        } else if (object instanceof Float) {
            if (Properties.RESTRICT_POOL) {
                float val = ((Float)object).floatValue();
                if (Math.abs(val) < (float)Properties.MAX_INT) {
                    this.floatPool.restrictedAdd((Float)object);
                }
            } else {
                this.floatPool.restrictedAdd((Float)object);
            }
        } else if (object instanceof Double) {
            if (Properties.RESTRICT_POOL) {
                double val = (Double)object;
                if (Math.abs(val) < (double)Properties.MAX_INT) {
                    this.doublePool.restrictedAdd((Double)object);
                }
            } else {
                this.doublePool.restrictedAdd((Double)object);
            }
        }
    }

    @Override
    public String toString() {
        String res = new String("DynamicConstantPool:{");
        res = res + "stringPool=" + this.stringPool.toString() + " ; ";
        res = res + "typePool=" + this.typePool.toString() + " ; ";
        res = res + "intPool=" + this.intPool.toString() + " ; ";
        res = res + "longPool=" + this.longPool.toString() + " ; ";
        res = res + "floatPool=" + this.floatPool.toString() + " ; ";
        res = res + "doublePool=" + this.doublePool.toString() + "}";
        return res;
    }
}

