/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding.factories;

import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class BIAndRITestSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = 1L;
    private final ChromosomeFactory<TestSuiteChromosome> defaultFactory;
    private final GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm;
    private boolean seeded = false;

    public BIAndRITestSuiteChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> defaultFactory, GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm) {
        this.defaultFactory = defaultFactory;
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        TestSuiteChromosome chrom = null;
        if (!this.seeded && this.geneticAlgorithm != null) {
            this.seeded = true;
            chrom = this.geneticAlgorithm.getBestIndividual();
        } else if (this.geneticAlgorithm != null && Randomness.nextDouble() < Properties.SEED_PROBABILITY) {
            int populationSize = this.geneticAlgorithm.getPopulation().size();
            chrom = this.geneticAlgorithm.getPopulation().get(Randomness.nextInt(populationSize));
        }
        if (chrom == null) {
            chrom = this.defaultFactory.getChromosome();
        }
        return chrom;
    }
}

