/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.seeding.factories;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.runtime.Random;
import org.evosuite.testcase.TestCase;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class RandomMethodSeedingTestSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = 1L;
    private final ChromosomeFactory<TestSuiteChromosome> defaultFactory;
    private final GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm;

    public RandomMethodSeedingTestSuiteChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> defaultFactory, GeneticAlgorithm<TestSuiteChromosome> geneticAlgorithm) {
        this.defaultFactory = defaultFactory;
        this.geneticAlgorithm = geneticAlgorithm;
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        TestSuiteChromosome chromosome = this.defaultFactory.getChromosome();
        int numTests = chromosome.getTests().size();
        double SEED_CHANCE = Properties.SEED_PROBABILITY / (double)numTests;
        for (int i = 0; i < numTests; ++i) {
            if (this.geneticAlgorithm == null || !(Randomness.nextDouble() < SEED_CHANCE)) continue;
            int populationSize = this.geneticAlgorithm.getPopulation().size();
            TestSuiteChromosome tsc = this.geneticAlgorithm.getPopulation().get(Randomness.nextInt(populationSize));
            int testSize = tsc.getTests().size();
            TestCase test = tsc.getTests().get(Random.nextInt((int)testSize));
            if (test == null) continue;
            List<TestCase> tests = chromosome.getTests();
            tests.remove(i);
            tests.add(i, test);
            chromosome.clearTests();
            for (TestCase t : tests) {
                chromosome.addTest(t);
            }
        }
        return chromosome;
    }
}

