/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup;

import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.setup.TestUsageChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteClassAnalyzer {
    private static Logger logger = LoggerFactory.getLogger(ConcreteClassAnalyzer.class);
    private static ConcreteClassAnalyzer instance;
    private Map<Class<?>, Set<Class<?>>> cache = new LinkedHashMap();

    private ConcreteClassAnalyzer() {
    }

    public static ConcreteClassAnalyzer getInstance() {
        if (instance == null) {
            instance = new ConcreteClassAnalyzer();
        }
        return instance;
    }

    public void clear() {
        this.cache.clear();
    }

    public Set<Class<?>> getConcreteClasses(Class<?> clazz, InheritanceTree inheritanceTree) {
        if (this.cache.containsKey(clazz)) {
            return this.cache.get(clazz);
        }
        Set<Class<?>> classes = this.getConcreteClassesImpl(clazz, inheritanceTree);
        this.cache.put(clazz, classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> getConcreteClassesImpl(Class<?> clazz, InheritanceTree inheritanceTree) {
        if (clazz.equals(Map.class)) {
            return this.getConcreteClassesMap();
        }
        if (clazz.equals(List.class)) {
            return this.getConcreteClassesList();
        }
        if (clazz.equals(Set.class)) {
            return this.getConcreteClassesSet();
        }
        if (clazz.equals(Collection.class)) {
            return this.getConcreteClassesList();
        }
        if (clazz.equals(Iterator.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(ListIterator.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(Serializable.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(Comparable.class)) {
            return this.getConcreteClassesComparable();
        }
        if (clazz.equals(Comparator.class)) {
            return new LinkedHashSet();
        }
        if (clazz.equals(Reader.class)) {
            return this.getConcreteClassesReader();
        }
        if (clazz.equals(Writer.class)) {
            return this.getConcreteClassesWriter();
        }
        LinkedHashSet actualClasses = new LinkedHashSet();
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || clazz.equals(Enum.class)) {
            String className = clazz.getName();
            if (MockList.isAMockClass((String)className)) {
                className = clazz.getSuperclass().getName();
            }
            Set<String> subClasses = inheritanceTree.getSubclasses(className);
            logger.debug("Subclasses of " + clazz.getName() + ": " + subClasses);
            HashMap<String, Integer> classDistance = new HashMap<String, Integer>();
            int maxDistance = -1;
            String name = clazz.getName();
            if (clazz.equals(Enum.class)) {
                name = Properties.TARGET_CLASS;
            }
            for (String subClass : subClasses) {
                int distance = TestClusterUtils.getPackageDistance(subClass, name);
                classDistance.put(subClass, distance);
                maxDistance = Math.max(distance, maxDistance);
            }
            for (int distance = 0; actualClasses.isEmpty() && distance <= maxDistance; ++distance) {
                logger.debug(" Current distance: " + distance);
                for (String subClass : subClasses) {
                    if (TestClusterUtils.isAnonymousClass(subClass) || (Integer)classDistance.get(subClass) != distance) continue;
                    try {
                        TestGenerationContext.getInstance().goingToExecuteSUTCode();
                        Class subClazz = Class.forName(subClass, false, TestGenerationContext.getInstance().getClassLoaderForSUT());
                        if (!TestUsageChecker.canUse(subClazz) || subClazz.isInterface() || Modifier.isAbstract(subClazz.getModifiers()) && !TestClusterUtils.hasStaticGenerator(subClazz)) continue;
                        Class mock = MockList.getMockClass((String)subClazz.getCanonicalName());
                        if (mock != null) {
                            logger.debug("Adding mock " + mock + " instead of " + clazz);
                            subClazz = mock;
                        } else if (!TestClusterUtils.checkIfCanUse(subClazz.getCanonicalName())) continue;
                        actualClasses.add(subClazz);
                    }
                    catch (ClassNotFoundException | IncompatibleClassChangeError | NoClassDefFoundError e) {
                        logger.error("Problem for " + Properties.TARGET_CLASS + ". Class not found: " + subClass, e);
                        logger.error("Removing class from inheritance tree");
                        inheritanceTree.removeClass(subClass);
                    }
                    finally {
                        TestGenerationContext.getInstance().doneWithExecutingSUTCode();
                    }
                }
            }
            if (TestClusterUtils.hasStaticGenerator(clazz)) {
                actualClasses.add(clazz);
            }
            if (actualClasses.isEmpty()) {
                logger.info("Don't know how to instantiate abstract class {}", (Object)clazz.getName());
            }
        } else {
            actualClasses.add(clazz);
        }
        logger.debug("Subclasses of " + clazz.getName() + ": " + actualClasses);
        return actualClasses;
    }

    private Set<Class<?>> getConcreteClassesMap() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> mapClazz = Class.forName("java.util.HashMap", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(mapClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return mapClasses;
    }

    private Set<Class<?>> getConcreteClassesList() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> mapClazz = Class.forName("java.util.LinkedList", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(mapClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return mapClasses;
    }

    private Set<Class<?>> getConcreteClassesSet() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> setClazz = Class.forName("java.util.LinkedHashSet", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(setClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return mapClasses;
    }

    private Set<Class<?>> getConcreteClassesReader() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> setClazz = Class.forName("java.io.StringReader", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(setClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return mapClasses;
    }

    private Set<Class<?>> getConcreteClassesWriter() {
        LinkedHashSet mapClasses = new LinkedHashSet();
        try {
            Class<?> setClazz = Class.forName("java.io.StringWriter", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            mapClasses.add(setClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return mapClasses;
    }

    private Set<Class<?>> getConcreteClassesComparable() {
        LinkedHashSet comparableClasses = new LinkedHashSet();
        try {
            Class<?> comparableClazz = Class.forName("java.lang.Integer", false, TestGenerationContext.getInstance().getClassLoaderForSUT());
            comparableClasses.add(comparableClazz);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage());
        }
        return comparableClasses;
    }
}

