/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup.callgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class Graph<E> {
    private final Map<E, Set<E>> edges = Collections.synchronizedMap(new HashMap());
    private final Map<E, Set<E>> reverseEdges = Collections.synchronizedMap(new HashMap());
    private final Set<E> vertexSet = Collections.synchronizedSet(new HashSet());

    public Map<E, Set<E>> getEdges() {
        return this.edges;
    }

    public synchronized void removeVertex(E vertex) {
        this.edges.remove(vertex);
        this.reverseEdges.remove(vertex);
        this.vertexSet.remove(vertex);
    }

    public synchronized boolean containsEdge(E src, E dest) {
        Set<E> tempSet = this.edges.get(src);
        if (tempSet == null) {
            return false;
        }
        return tempSet.contains(dest);
    }

    public synchronized void addEdge(E src, E dest) {
        this.vertexSet.add(src);
        this.vertexSet.add(dest);
        Set<E> srcNeighbors = this.edges.get(src);
        if (srcNeighbors == null) {
            srcNeighbors = new LinkedHashSet();
            this.edges.put(src, srcNeighbors);
        }
        srcNeighbors.add(dest);
        Set<E> rsrcNeighbors = this.reverseEdges.get(dest);
        if (rsrcNeighbors == null) {
            rsrcNeighbors = new LinkedHashSet();
            this.reverseEdges.put(dest, rsrcNeighbors);
        }
        rsrcNeighbors.add(src);
    }

    public synchronized Set<E> getVertexSet() {
        return this.vertexSet;
    }

    public synchronized boolean containsVertex(E e) {
        return this.vertexSet.contains(e);
    }

    public synchronized Iterable<E> getNeighbors(E vertex) {
        Set<E> neighbors = this.edges.get(vertex);
        if (neighbors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(neighbors);
    }

    public synchronized Iterable<E> getReverseNeighbors(E vertex) {
        Set<E> neighbors = this.reverseEdges.get(vertex);
        if (neighbors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableSet(neighbors);
    }

    public synchronized int getNeighborsSize(E vertex) {
        if (this.edges.get(vertex) == null) {
            return 0;
        }
        return this.edges.get(vertex).size();
    }
}

