/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.setup.callgraph;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.evosuite.setup.callgraph.Graph;

public class PathFinderDFSIterator<E>
implements Iterator<E> {
    private Set<E> visited = new HashSet();
    private Deque<Iterator<E>> stack = new LinkedList<Iterator<E>>();
    private Graph<E> graph;
    private E next;
    private Set<List<E>> paths = new HashSet<List<E>>();
    private List<E> currentPath = new ArrayList();
    private boolean reversed = false;

    public PathFinderDFSIterator(Graph<E> g, E startingVertex) {
        this(g, startingVertex, false);
    }

    public PathFinderDFSIterator(Graph<E> g, E startingVertex, boolean reversed) {
        if (!reversed) {
            this.stack.push(g.getNeighbors(startingVertex).iterator());
        } else {
            this.stack.push(g.getReverseNeighbors(startingVertex).iterator());
        }
        this.graph = g;
        this.next = startingVertex;
        this.paths.add(this.currentPath);
        this.reversed = reversed;
    }

    public Set<List<E>> getPaths() {
        return this.paths;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        try {
            this.visited.add(this.next);
            this.currentPath.add(this.next);
            E e = this.next;
            return e;
        }
        finally {
            this.advance();
        }
    }

    private void advance() {
        Iterator<E> neighbors = this.stack.peek();
        boolean update = false;
        do {
            int levelback = 0;
            while (!neighbors.hasNext()) {
                this.stack.pop();
                if (this.stack.isEmpty()) {
                    this.next = null;
                    return;
                }
                neighbors = this.stack.peek();
                ++levelback;
                update = true;
            }
            if (update) {
                ArrayList<E> newPath = new ArrayList<E>(this.currentPath.subList(0, this.currentPath.size() - levelback));
                this.currentPath = newPath;
                this.paths.add(newPath);
                update = false;
            }
            this.next = neighbors.next();
        } while (this.visited.contains(this.next));
        if (!this.reversed) {
            this.stack.push(this.graph.getNeighbors(this.next).iterator());
        } else {
            this.stack.push(this.graph.getReverseNeighbors(this.next).iterator());
        }
    }
}

